/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import com.sun.jersey.core.util.Base64;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;

public class AuthorizationHeadersTest {
    @Test
    public void shouldParseHappyPath() throws Exception {
        String token = "12345";
        String header = "Basic realm=\"Neo4j\" " + this.base64(":" + token);
        String parsed = AuthorizationHeaders.extractToken((String)header);
        Assert.assertEquals((Object)token, (Object)parsed);
    }

    @Test
    public void shouldHandleSadPaths() throws Exception {
        Assert.assertEquals((Object)"", (Object)AuthorizationHeaders.extractToken((String)""));
        Assert.assertEquals((Object)"", (Object)AuthorizationHeaders.extractToken(null));
        Assert.assertEquals((Object)"", (Object)AuthorizationHeaders.extractToken((String)"Basic"));
        Assert.assertEquals((Object)"", (Object)AuthorizationHeaders.extractToken((String)"Basic realm=\"Neo4j\" not valid value"));
        Assert.assertEquals((Object)"", (Object)AuthorizationHeaders.extractToken((String)("Basic realm=\"Neo4j\" " + this.base64(""))));
        Assert.assertEquals((Object)"", (Object)AuthorizationHeaders.extractToken((String)("Basic realm=\"Neo4j\" " + this.base64(":"))));
    }

    private String base64(String value) {
        return new String(Base64.encode((String)value), Charset.forName("UTF-8"));
    }
}

