/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.io.File;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.security.auth.Credentials;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.Privileges;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.auth.exception.IllegalTokenException;
import org.neo4j.test.EphemeralFileSystemRule;

public class FileUserRepositoryTest {
    @Rule
    public EphemeralFileSystemRule fsRule = new EphemeralFileSystemRule();

    @Test
    public void shouldStoreAndRetriveUsersByName() throws Exception {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        User result = users.findByName(user.name());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)user));
    }

    @Test
    public void shouldStoreAndRetriveUsersByToken() throws Exception {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        User result = users.findByToken(user.token());
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)user));
    }

    @Test
    public void shouldPersistUsers() throws Throwable {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        users.start();
        User resultByName = users.findByName(user.name());
        User resultByToken = users.findByToken(user.token());
        MatcherAssert.assertThat((Object)resultByName, (Matcher)CoreMatchers.equalTo((Object)user));
        MatcherAssert.assertThat((Object)resultByToken, (Matcher)CoreMatchers.equalTo((Object)user));
    }

    @Test
    public void shouldNotFindUserByTokenAfterChangingToken() throws Throwable {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        User updatedUser = new User("jake", "321fa", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.update(user, updatedUser);
        MatcherAssert.assertThat((Object)users.findByToken(updatedUser.token()), (Matcher)CoreMatchers.equalTo((Object)updatedUser));
        MatcherAssert.assertThat((Object)users.findByToken(user.token()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldNotAllowComplexNames() throws Exception {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        Assert.assertTrue((boolean)users.isValidName("neo4j"));
        Assert.assertTrue((boolean)users.isValidName("johnosbourne"));
        Assert.assertTrue((boolean)users.isValidName("john_osbourne"));
        Assert.assertFalse((boolean)users.isValidName(":"));
        Assert.assertFalse((boolean)users.isValidName(""));
        Assert.assertFalse((boolean)users.isValidName("john osbourne"));
        Assert.assertFalse((boolean)users.isValidName("john:osbourne"));
    }

    @Test
    public void shouldRecoverIfCrashedDuringWrite() throws Throwable {
        File dbFile = new File("dbms/auth.db");
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), dbFile);
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        File tempFile = new File(dbFile.getAbsolutePath() + ".tmp");
        this.fsRule.get().renameFile(dbFile, tempFile);
        users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), dbFile);
        users.start();
        Assert.assertFalse((boolean)this.fsRule.get().fileExists(tempFile));
        Assert.assertTrue((boolean)this.fsRule.get().fileExists(dbFile));
        MatcherAssert.assertThat((Object)users.findByName(user.name()), (Matcher)CoreMatchers.equalTo((Object)user));
    }

    @Test
    public void shouldThrowIfUpdateChangesName() throws Throwable {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        User updatedUser = new User("john", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        try {
            users.update(user, updatedUser);
            Assert.fail((String)"expected exception not thrown");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)users.findByToken(user.token()), (Matcher)CoreMatchers.equalTo((Object)user));
    }

    @Test
    public void shouldThrowIfExistingUserDoesNotMatch() throws Throwable {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        User modifiedUser = new User("jake", "af123_2", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        User updatedUser = new User("jake", "123abc", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        try {
            users.update(modifiedUser, updatedUser);
            Assert.fail((String)"expected exception not thrown");
        }
        catch (ConcurrentModificationException e) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)users.findByToken(user.token()), (Matcher)CoreMatchers.equalTo((Object)user));
        MatcherAssert.assertThat((Object)users.findByToken(modifiedUser.token()), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)users.findByToken(updatedUser.token()), (Matcher)CoreMatchers.nullValue());
    }

    @Test
    public void shouldThrowIfUpdatedUserHasDuplicateToken() throws Throwable {
        FileUserRepository users = new FileUserRepository((FileSystemAbstraction)this.fsRule.get(), new File("dbms/auth.db"));
        User user = new User("jake", "af123", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(user);
        User otherUser = new User("john", "abc", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        users.create(otherUser);
        User updatedUser = new User("jake", "abc", Privileges.ADMIN, Credentials.INACCESSIBLE, true);
        try {
            users.update(user, updatedUser);
            Assert.fail((String)"expected exception not thrown");
        }
        catch (IllegalTokenException e) {
            // empty catch block
        }
        MatcherAssert.assertThat((Object)users.findByToken(user.token()), (Matcher)CoreMatchers.equalTo((Object)user));
        MatcherAssert.assertThat((Object)users.findByToken(otherUser.token()), (Matcher)CoreMatchers.equalTo((Object)otherUser));
    }
}

