/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;
import org.neo4j.server.security.auth.exception.IllegalTokenException;
import org.neo4j.server.security.auth.exception.IllegalUsernameException;

public class InMemoryUserRepository
implements UserRepository {
    private final ConcurrentHashMap<String, User> users = new ConcurrentHashMap();

    public User findByName(String name) {
        return this.users.get(name);
    }

    public User findByToken(String token) {
        for (User user : this.users.values()) {
            if (!user.token().equals(token)) continue;
            return user;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(User user) throws IllegalUsernameException, IllegalTokenException {
        InMemoryUserRepository inMemoryUserRepository = this;
        synchronized (inMemoryUserRepository) {
            for (User other : this.users.values()) {
                if (other.name().equals(user.name())) {
                    throw new IllegalUsernameException("The specified user already exists");
                }
                if (!other.token().equals(user.token())) continue;
                throw new IllegalTokenException("The specified token is already in use");
            }
            this.users.put(user.name(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(User existingUser, User updatedUser) throws IllegalTokenException, ConcurrentModificationException {
        if (!existingUser.name().equals(updatedUser.name())) {
            throw new IllegalArgumentException("updatedUser has a different name");
        }
        InMemoryUserRepository inMemoryUserRepository = this;
        synchronized (inMemoryUserRepository) {
            boolean foundUser = false;
            for (User other : this.users.values()) {
                if (other.equals((Object)existingUser)) {
                    foundUser = true;
                    continue;
                }
                if (!other.token().equals(updatedUser.token())) continue;
                throw new IllegalTokenException("The specified token is already in use");
            }
            if (!foundUser) {
                throw new ConcurrentModificationException();
            }
            this.users.put(updatedUser.name(), updatedUser);
        }
    }

    public int numberOfUsers() {
        return this.users.size();
    }

    public boolean isValidName(String name) {
        return true;
    }

    public boolean isValidToken(String token) {
        return true;
    }
}

