/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.Privileges;
import org.neo4j.server.security.auth.SecurityCentral;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.IllegalTokenException;

public class SecurityCentralTest {
    @Test
    public void shouldKeepPersistentToken() throws Exception {
        SecurityCentral security = new SecurityCentral((Clock)new FakeClock(), (UserRepository)new InMemoryUserRepository());
        security.newUser("neo4j", "neo4j", true, Privileges.ADMIN);
        security.regenerateToken("neo4j");
        String token = security.userForName("neo4j").token();
        User user = security.userForToken(token);
        Assert.assertThat((Object)user.name(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
    }

    @Test
    public void shouldRegenerateToken() throws Exception {
        SecurityCentral security = new SecurityCentral((Clock)new FakeClock(), (UserRepository)new InMemoryUserRepository());
        security.newUser("neo4j", "neo4j", true, Privileges.ADMIN);
        String oldToken = security.userForName("neo4j").token();
        security.userForToken(oldToken);
        User updatedUser = security.regenerateToken("neo4j");
        Assert.assertThat((Object)security.userForName("neo4j").token(), (Matcher)CoreMatchers.equalTo((Object)updatedUser.token()));
        Assert.assertThat((Object)security.userForToken(updatedUser.token()).name(), (Matcher)CoreMatchers.equalTo((Object)"neo4j"));
        Assert.assertThat((Object)security.userForToken(oldToken).name(), (Matcher)CoreMatchers.equalTo((Object)SecurityCentral.UNAUTHENTICATED.name()));
    }

    @Test
    public void shouldNotAllowSettingDuplicateTokens() throws Exception {
        SecurityCentral security = new SecurityCentral((Clock)new FakeClock(), (UserRepository)new InMemoryUserRepository());
        security.newUser("neo4j", "neo4j", true, Privileges.ADMIN);
        security.newUser("other", "other", true, Privileges.ADMIN);
        security.regenerateToken("neo4j");
        String neo4jUserToken = security.userForName("neo4j").token();
        try {
            security.setToken("other", neo4jUserToken);
            Assert.fail((String)"Should not have been allowed.");
        }
        catch (IllegalTokenException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"The specified token is already in use"));
        }
    }
}

