/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.server.security.auth.Credentials;
import org.neo4j.server.security.auth.Privileges;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserSerialization;

public class UserSerializationTest {
    @Test
    public void shouldSerializeAndDeserialize() throws Exception {
        UserSerialization serialization = new UserSerialization();
        List<User> users = Arrays.asList(new User("Steve", "12345", Privileges.ADMIN, new Credentials("SomeSalt", "SomeAlgo", "1234321"), false), new User("Bob", "54321", Privileges.ADMIN, new Credentials("OtherSalt", "OtherAlgo", "0987654"), false));
        byte[] serialized = serialization.serialize(users);
        MatcherAssert.assertThat((Object)serialization.deserializeUsers(serialized), (Matcher)Matchers.equalTo(users));
    }

    @Test
    public void shouldReadV1SerializationFormat() throws Exception {
        UserSerialization serialization = new UserSerialization();
        List deserialized = serialization.deserializeUsers("Steve:12345:SomeAlgo,1234321,SomeSalt:\nBob:abcde:OtherAlgo,0987654,OtherSalt:password_change_required".getBytes(Charsets.UTF_8));
        MatcherAssert.assertThat((Object)deserialized, (Matcher)Matchers.equalTo(Arrays.asList(new User("Steve", "12345", Privileges.ADMIN, new Credentials("SomeSalt", "SomeAlgo", "1234321"), false), new User("Bob", "abcde", Privileges.ADMIN, new Credentials("OtherSalt", "OtherAlgo", "0987654"), true))));
    }
}

