/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.test.TargetDirectory;

public class HTTPLoggingPreparednessRuleTest {
    @Test
    public void shouldPassWhenExplicitlyDisabled() {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{Configurator.HTTP_LOGGING, "false"}));
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging(config);
        boolean result = rule.run();
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldPassWhenImplicitlyDisabled() {
        Config config = new Config();
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging(config);
        boolean result = rule.run();
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldPassWhenEnabledWithGoodConfigSpecified() throws Exception {
        File logDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("logDir");
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("confDir");
        Config config = new Config(MapUtil.stringMap((String[])new String[]{Configurator.HTTP_LOGGING, "true", Configurator.HTTP_LOG_CONFIG_LOCATION, HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDir), confDir).getAbsolutePath()}));
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging(config);
        boolean result = rule.run();
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((Object)"", (Object)rule.getFailureMessage());
    }

    @Test
    public void shouldFailWhenEnabledWithUnwritableLogDirSpecifiedInConfig() throws Exception {
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("confDir");
        File unwritableDirectory = HTTPLoggingPreparednessRuleTest.createUnwritableDirectory();
        Config config = new Config(MapUtil.stringMap((String[])new String[]{Configurator.HTTP_LOGGING, "true", Configurator.HTTP_LOG_CONFIG_LOCATION, HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableDirectory), confDir).getAbsolutePath()}));
        EnsurePreparedForHttpLogging rule = new EnsurePreparedForHttpLogging(config);
        boolean result = rule.run();
        Assert.assertFalse((boolean)result);
        Assert.assertEquals((Object)String.format("HTTP log directory [%s] does not exist", unwritableDirectory), (Object)rule.getFailureMessage());
    }

    public static File createUnwritableDirectory() {
        File file = Settings.osIsWindows() ? new File("\\\\" + UUID.randomUUID().toString() + "\\") : (Settings.osIsMacOS() ? new File("/Network/Servers/localhost/" + UUID.randomUUID().toString()) : new File("/proc/" + UUID.randomUUID().toString() + "/random"));
        return file;
    }

    public static File createConfigFile(String configXml, File location) throws IOException {
        File configFile = new File(location.getAbsolutePath() + File.separator + "neo4j-logback-config.xml");
        FileOutputStream fos = new FileOutputStream(configFile);
        fos.write(configXml.getBytes());
        fos.close();
        return configFile;
    }

    public static String createLogbackConfigXml(File logDirectory) {
        return HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory, "%h %l %user [%t{dd/MMM/yyyy:HH:mm:ss Z}] \"%r\" %s %b \"%i{Referer}\" \"%i{User-Agent}\"");
    }

    public static String createLogbackConfigXml(File logDirectory, String logPattern) {
        return "<configuration>\n  <appender name=\"FILE\" class=\"ch.qos.logback.core.rolling.RollingFileAppender\">\n    <file>" + logDirectory.getAbsolutePath() + File.separator + "http.log</file>\n" + "    <rollingPolicy class=\"ch.qos.logback.core.rolling.TimeBasedRollingPolicy\">\n" + "      <fileNamePattern>" + logDirectory.getAbsolutePath() + File.separator + "http.%d{yyyy-MM-dd_HH}.log</fileNamePattern>\n" + "      <maxHistory>30</maxHistory>\n" + "    </rollingPolicy>\n" + "\n" + "    <encoder>\n" + "      <!-- Note the deliberate misspelling of \"referer\" in accordance with RFC 2616 -->\n" + "      <pattern>" + logPattern + "</pattern>\n" + "    </encoder>\n" + "  </appender>\n" + "\n" + "  <appender-ref ref=\"FILE\" />\n" + "</configuration>";
    }
}

