/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import com.sun.jersey.core.util.Base64;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.rest.dbms.AuthorizationHeaders;

public class AuthorizationHeadersTest {
    @Test
    public void shouldParseHappyPath() throws Exception {
        String username = "jake";
        String password = "qwerty123456";
        String header = "Basic realm=\"Neo4j\" " + this.base64(username + ":" + password);
        String[] parsed = AuthorizationHeaders.decode((String)header);
        Assert.assertEquals((Object)username, (Object)parsed[0]);
        Assert.assertEquals((Object)password, (Object)parsed[1]);
    }

    @Test
    public void shouldHandleSadPaths() throws Exception {
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)""));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)"Basic"));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)"Basic realm=\"Neo4j\" not valid value"));
        Assert.assertNull((Object)AuthorizationHeaders.decode((String)("Basic realm=\"Neo4j\" " + this.base64(""))));
    }

    private String base64(String value) {
        return new String(Base64.encode((String)value), Charset.forName("UTF-8"));
    }
}

