/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.RrdDbWrapper;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rrd.JobScheduler;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.server.rrd.Sampleable;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.Mute;
import org.neo4j.test.TargetDirectory;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

public class RrdFactoryTest {
    private Config config;
    private Database db;
    TargetDirectory target = TargetDirectory.forTest(RrdFactoryTest.class);
    @Rule
    public TargetDirectory.TestDirectory testDirectory = this.target.testDirectory();
    @Rule
    public Mute mute = Mute.muteAll();

    @Before
    public void setUp() throws IOException {
        this.db = new WrappedDatabase((GraphDatabaseAPI)new ImpermanentGraphDatabase(TargetDirectory.forTest(this.getClass()).cleanDirectory("rrd").getAbsolutePath()));
        this.config = new Config();
    }

    @After
    public void tearDown() {
        this.db.getGraph().shutdown();
    }

    @Test
    public void shouldTakeDirectoryLocationFromConfig() throws Exception {
        String expected = this.testDirectory.directory().getAbsolutePath();
        this.addProperty(Configurator.RRDB_LOCATION_PROPERTY_KEY, expected);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    private void addProperty(String rrdbLocationPropertyKey, String expected) {
        Map params = this.config.getParams();
        params.put(rrdbLocationPropertyKey, expected);
        this.config.applyChanges(params);
    }

    @Test
    public void recreateDatabaseIfWrongStepsize() throws Exception {
        String expected = this.testDirectory.directory().getAbsolutePath();
        this.addProperty(Configurator.RRDB_LOCATION_PROPERTY_KEY, expected);
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldMoveAwayInvalidRrdFile() throws IOException {
        String expected = new File(this.testDirectory.directory(), "rrd-test").getAbsolutePath();
        this.addProperty(Configurator.RRDB_LOCATION_PROPERTY_KEY, expected);
        TestableRrdFactory factory = this.createRrdFactory();
        this.createInvalidRrdFile(expected);
        RrdDbWrapper rrdDbAndSampler = factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        this.assertSubdirectoryExists("rrd-test-invalid", factory.directoryUsed);
        rrdDbAndSampler.close();
    }

    private void createInvalidRrdFile(String expected) throws IOException {
        File rrd = new File(expected);
        RrdDef rrdDef = new RrdDef(rrd.getAbsolutePath(), 3000L);
        rrdDef.addDatasource("test", DsType.GAUGE, 1L, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.2, 1, 1600);
        RrdDb r = new RrdDb(rrdDef);
        r.close();
    }

    @Test
    public void shouldCreateRrdFileInTempLocationForImpermanentDatabases() throws IOException {
        String expected = this.testDirectory.directory().getAbsolutePath();
        TestableRrdFactory factory = this.createRrdFactory(expected);
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        Assert.assertThat((Object)factory.directoryUsed, (Matcher)CoreMatchers.is((Object)expected));
    }

    @Test
    public void shouldCreateRrdFileInDbSubdirectory() throws Exception {
        String storeDir = this.testDirectory.directory().getAbsolutePath();
        this.db = new WrappedDatabase((GraphDatabaseAPI)((InternalAbstractGraphDatabase)new GraphDatabaseFactory().newEmbeddedDatabase(storeDir)));
        TestableRrdFactory factory = this.createRrdFactory();
        factory.createRrdDbAndSampler(this.db, new NullJobScheduler());
        String rrdParent = new File(factory.directoryUsed).getParent();
        Assert.assertThat((Object)rrdParent, (Matcher)CoreMatchers.is((Object)storeDir));
    }

    private void assertSubdirectoryExists(String directoryThatShouldExist, String directoryUsed) {
        String[] list;
        File parentFile = new File(directoryUsed).getParentFile();
        for (String aList : list = parentFile.list()) {
            if (!aList.startsWith(directoryThatShouldExist)) continue;
            return;
        }
        Assert.fail((String)String.format("Didn't find [%s] in [%s]", directoryThatShouldExist, directoryUsed));
    }

    private TestableRrdFactory createRrdFactory() {
        return new TestableRrdFactory(this.config, new File(this.testDirectory.directory(), "rrd").getAbsolutePath());
    }

    private TestableRrdFactory createRrdFactory(String tempRrdFile) {
        return new TestableRrdFactory(this.config, tempRrdFile);
    }

    private static class NullJobScheduler
    implements JobScheduler {
        private NullJobScheduler() {
        }

        public void scheduleAtFixedRate(Runnable job, String name, long delay, long period) {
        }
    }

    private static class TestableRrdFactory
    extends RrdFactory {
        public String directoryUsed;
        private final String tempRrdFile;

        public TestableRrdFactory(Config config, String tempRrdFile) {
            super(config, DevNullLoggingService.DEV_NULL);
            this.tempRrdFile = tempRrdFile;
        }

        protected String tempRrdFile() throws IOException {
            return this.tempRrdFile;
        }

        protected RrdDbWrapper createRrdb(File inDirectory, boolean ephemeral, Sampleable ... sampleables) {
            this.directoryUsed = inDirectory.getAbsolutePath();
            return super.createRrdb(inDirectory, ephemeral, sampleables);
        }
    }
}

