/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.security.auth.AuthenticationResult;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;

public class AuthManagerTest {
    @Test
    public void shouldCreateDefaultUserIfNoneExist() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        AuthManager manager = new AuthManager((UserRepository)users, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        User user = users.findByName("neo4j");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.credentials().matchesPassword("neo4j"));
        Assert.assertTrue((boolean)user.passwordChangeRequired());
    }

    @Test
    public void shouldFindAndAuthenticateUserSuccessfully() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User("jake", Credential.forPassword((String)"abc123"), false);
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        AuthManager manager = new AuthManager((UserRepository)users, authStrategy);
        manager.start();
        Mockito.when((Object)authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.SUCCESS);
        AuthenticationResult result = manager.authenticate("jake", "abc123");
        ((AuthenticationStrategy)Mockito.verify((Object)authStrategy)).authenticate(user, "abc123");
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldFindAndAuthenticateUserAndReturnAuthStrategyResult() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User("jake", Credential.forPassword((String)"abc123"), true);
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        AuthManager manager = new AuthManager((UserRepository)users, authStrategy);
        manager.start();
        Mockito.when((Object)authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        AuthenticationResult result = manager.authenticate("jake", "abc123");
        ((AuthenticationStrategy)Mockito.verify((Object)authStrategy)).authenticate(user, "abc123");
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
    }

    @Test
    public void shouldFindAndAuthenticateUserAndReturnPasswordChangeIfRequired() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User("jake", Credential.forPassword((String)"abc123"), true);
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        AuthManager manager = new AuthManager((UserRepository)users, authStrategy);
        manager.start();
        Mockito.when((Object)authStrategy.authenticate(user, "abc123")).thenReturn((Object)AuthenticationResult.SUCCESS);
        AuthenticationResult result = manager.authenticate("jake", "abc123");
        ((AuthenticationStrategy)Mockito.verify((Object)authStrategy)).authenticate(user, "abc123");
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED));
    }

    @Test
    public void shouldFailAuthenticationIfUserIsNotFound() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User("jake", Credential.forPassword((String)"abc123"), true);
        users.create(user);
        AuthenticationStrategy authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        AuthManager manager = new AuthManager((UserRepository)users, authStrategy);
        manager.start();
        AuthenticationResult result = manager.authenticate("unknown", "abc123");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{authStrategy});
        Assert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldCreateUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        AuthManager manager = new AuthManager((UserRepository)users, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        manager.newUser("foo", "bar", true);
        User user = users.findByName("foo");
        Assert.assertNotNull((Object)user);
        Assert.assertTrue((boolean)user.passwordChangeRequired());
        Assert.assertTrue((boolean)user.credentials().matchesPassword("bar"));
    }

    @Test
    public void shouldDeleteUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User("jake", Credential.forPassword((String)"abc123"), true);
        users.create(user);
        AuthManager manager = new AuthManager((UserRepository)users, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        manager.deleteUser("jake");
        Assert.assertNull((Object)users.findByName("jake"));
    }

    @Test
    public void shouldDeleteUnknownUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        User user = new User("jake", Credential.forPassword((String)"abc123"), true);
        users.create(user);
        AuthManager manager = new AuthManager((UserRepository)users, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        manager.deleteUser("unknown");
        Assert.assertNotNull((Object)users.findByName("jake"));
    }

    @Test
    public void shouldSetPassword() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        users.create(new User("jake", Credential.forPassword((String)"abc123"), true));
        AuthManager manager = new AuthManager((UserRepository)users, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        User user = manager.setPassword("jake", "hello, world!");
        Assert.assertTrue((boolean)user.credentials().matchesPassword("hello, world!"));
        Assert.assertThat((Object)users.findByName("jake"), (Matcher)Matchers.equalTo((Object)user));
    }

    @Test
    public void shouldReturnNullWhenSettingPasswordForUnknownUser() throws Throwable {
        InMemoryUserRepository users = new InMemoryUserRepository();
        AuthManager manager = new AuthManager((UserRepository)users, (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class));
        manager.start();
        User user = manager.setPassword("unknown", "hello, world!");
        Assert.assertNull((Object)user);
    }
}

