/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.server.security.auth.AuthenticationResult;
import org.neo4j.server.security.auth.Credential;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.User;

public class RateLimitedAuthenticationStrategyTest {
    @Test
    public void shouldReturnSuccessForValidAttempt() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User("user", Credential.forPassword((String)"right"), false);
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }

    @Test
    public void shouldReturnFailureForInvalidAttempt() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User("user", Credential.forPassword((String)"right"), false);
        Assert.assertThat((Object)authStrategy.authenticate(user, "wrong"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.FAILURE));
    }

    @Test
    public void shouldSlowRequestRateOnMultipleFailedAttempts() throws Exception {
        FakeClock clock = new FakeClock();
        RateLimitedAuthenticationStrategy authStrategy = new RateLimitedAuthenticationStrategy((Clock)clock, 3);
        User user = new User("user", Credential.forPassword((String)"right"), false);
        authStrategy.authenticate(user, "wrong");
        authStrategy.authenticate(user, "wrong");
        authStrategy.authenticate(user, "wrong");
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.TOO_MANY_ATTEMPTS));
        clock.forward(5L, TimeUnit.SECONDS);
        Assert.assertThat((Object)authStrategy.authenticate(user, "right"), (Matcher)Matchers.equalTo((Object)AuthenticationResult.SUCCESS));
    }
}

