/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web.logging;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.preflight.EnsurePreparedForHttpLogging;
import org.neo4j.server.preflight.HTTPLoggingPreparednessRuleTest;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.test.AssertEventually;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;
import org.neo4j.test.server.HTTP;

public class HTTPLoggingDocIT
extends ExclusiveServerTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses() throws Exception {
        File logDirectory = TargetDirectory.forTest(this.getClass()).cleanDirectory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(Configurator.HTTP_LOGGING, "false").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).cleanDirectory("givenExplicitlyDisabledServerLoggingConfigurationShouldNotLogAccesses-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            String query = "?implicitlyDisabled" + UUID.randomUUID().toString();
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            Assert.assertFalse((boolean)this.occursIn(query, new File(logDirectory, "http.log")));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess() throws Exception {
        File logDirectory = TargetDirectory.forTest(this.getClass()).cleanDirectory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory), confDir);
        String query = "?explicitlyEnabled=" + UUID.randomUUID().toString();
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(Configurator.HTTP_LOGGING, "true").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).cleanDirectory("givenExplicitlyEnabledServerLoggingConfigurationShouldLogAccess-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            FunctionalTestHelper functionalTestHelper = new FunctionalTestHelper((NeoServer)server);
            JaxRsResponse response = new RestRequest().get(functionalTestHelper.webAdminUri() + query);
            Assert.assertEquals((long)200L, (long)response.getStatus());
            response.close();
            AssertEventually.assertEventually((String)"request appears in log", (int)5, (AssertEventually.Condition)this.logContains(logDirectory, query));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenDebugContentLoggingEnabledShouldLogContent() throws Exception {
        File logDirectory = TargetDirectory.forTest(this.getClass()).cleanDirectory("givenDebugContentLoggingEnabledShouldLogContent-logdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)logDirectory);
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("givenDebugContentLoggingEnabledShouldLogContent-confdir");
        org.apache.commons.io.FileUtils.forceMkdir((File)confDir);
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(logDirectory, "$requestContent\n%responseContent"), confDir);
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withProperty(Configurator.HTTP_LOGGING, "true").withProperty(Configurator.HTTP_CONTENT_LOGGING, "true").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(TargetDirectory.forTest(this.getClass()).cleanDirectory("givenDebugContentLoggingEnabledShouldLogContent-dbdir").getAbsolutePath()).build();
        try {
            server.start();
            HTTP.Response req = HTTP.POST(server.baseUri().resolve("/db/data/node").toString(), HTTP.RawPayload.rawPayload("{\"name\":\"Hello, world!\"}"));
            Assert.assertEquals((long)201L, (long)req.status());
            AssertEventually.assertEventually((String)"request appears in log", (int)5, (AssertEventually.Condition)this.logContains(logDirectory, "Hello, world!"));
            AssertEventually.assertEventually((String)"request appears in log", (int)5, (AssertEventually.Condition)this.logContains(logDirectory, "metadata"));
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenConfigurationWithUnwritableLogDirectoryShouldFailToStartServer() throws Exception {
        File confDir = TargetDirectory.forTest(this.getClass()).cleanDirectory("confdir");
        File unwritableLogDir = this.createUnwritableDirectory();
        File configFile = HTTPLoggingPreparednessRuleTest.createConfigFile(HTTPLoggingPreparednessRuleTest.createLogbackConfigXml(unwritableLogDir), confDir);
        Config config = new Config(MapUtil.stringMap((String[])new String[]{Configurator.HTTP_LOGGING, "true", Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()}));
        CommunityNeoServer server = CommunityServerBuilder.server().withDefaultDatabaseTuning().withPreflightTasks(new PreflightTask[]{new EnsurePreparedForHttpLogging(config)}).withProperty(Configurator.HTTP_LOGGING, "true").withProperty(Configurator.HTTP_LOG_CONFIG_LOCATION, configFile.getPath()).usingDatabaseDir(confDir.getAbsolutePath()).build();
        try {
            server.start();
            Assert.fail((String)"should have thrown exception");
        }
        catch (ServerStartupException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)String.format("HTTP log directory [%s]", unwritableLogDir.getAbsolutePath())));
        }
        finally {
            server.stop();
        }
    }

    private AssertEventually.Condition logContains(final File logDirectory, final String query) {
        return new AssertEventually.Condition(){

            public boolean evaluate() {
                return HTTPLoggingDocIT.this.occursIn(query, new File(logDirectory, "http.log"));
            }
        };
    }

    private File createUnwritableDirectory() {
        File file;
        if (Settings.osIsWindows()) {
            file = new File("\\\\" + UUID.randomUUID().toString() + "\\http.log");
        } else {
            TargetDirectory targetDirectory = TargetDirectory.forTest(this.getClass());
            file = targetDirectory.file("unwritable-" + System.currentTimeMillis());
            Assert.assertTrue((String)"create directory to be unwritable", (boolean)file.mkdirs());
            Assert.assertTrue((String)"mark directory as unwritable", (boolean)file.setWritable(false, false));
        }
        return file;
    }

    private boolean occursIn(String lookFor, File file) {
        if (!file.exists()) {
            return false;
        }
        try {
            String s = FileUtils.readTextFile((File)file, (Charset)Charsets.UTF_8);
            System.out.println(s);
            System.out.println();
            System.out.println("Does not contain: " + lookFor);
            return s.contains(lookFor);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

