/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webadmin.console;

import javax.servlet.http.HttpServletRequest;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.WrappedDatabase;
import org.neo4j.server.rest.management.console.CypherSession;
import org.neo4j.test.TestGraphDatabaseFactory;

public class CypherSessionDocTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReturnASingleNode() throws Throwable {
        InternalAbstractGraphDatabase graphdb = (InternalAbstractGraphDatabase)new TestGraphDatabaseFactory().newImpermanentDatabase();
        WrappedDatabase database = new WrappedDatabase((GraphDatabaseAPI)graphdb);
        CypherExecutor executor = new CypherExecutor((Database)database);
        executor.start();
        try {
            CypherSession session = new CypherSession(executor, DevNullLoggingService.DEV_NULL, (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
            Pair result = session.evaluate("create (a) return a");
            Assert.assertThat((Object)result.first(), (Matcher)CoreMatchers.containsString((String)"Node[0]"));
        }
        finally {
            graphdb.shutdown();
        }
    }
}

