/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.webdriver;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import org.neo4j.server.webdriver.WebdriverChromeDriver;
import org.neo4j.server.webdriver.WebdriverSauceLabsDriver;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebDriverFacade {
    private WebDriver browser;

    public WebDriver getWebDriver() throws InvocationTargetException, IllegalAccessException, InstantiationException {
        if (this.browser == null) {
            String driverName = this.lookupDriverImplementation();
            try {
                this.browser = WebDriverImplementation.valueOf(driverName).createInstance();
            }
            catch (Exception problem) {
                throw new RuntimeException("Couldn't instantiate the selected selenium driver. See nested exception.", problem);
            }
        }
        return this.browser;
    }

    private String lookupDriverImplementation() {
        String driverName = System.getProperty("webdriver.implementation", WebDriverImplementation.Firefox.name());
        System.out.println("Using " + driverName);
        return driverName;
    }

    public void quitBrowser() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.browser != null) {
            this.browser.quit();
        }
    }

    public static enum WebDriverImplementation {
        Firefox{

            @Override
            public WebDriver createInstance() {
                return new FirefoxDriver();
            }
        }
        ,
        Chrome{

            @Override
            public WebDriver createInstance() {
                WebdriverChromeDriver.ensurePresent();
                return new ChromeDriver();
            }
        }
        ,
        SauceLabsFirefoxWindows{

            @Override
            public WebDriver createInstance() throws MalformedURLException {
                DesiredCapabilities capabilities = DesiredCapabilities.firefox();
                capabilities.setCapability("version", "5");
                capabilities.setCapability("platform", Platform.VISTA);
                capabilities.setCapability("name", "Neo4j Web Testing");
                return WebdriverSauceLabsDriver.createDriver(capabilities);
            }
        }
        ,
        SauceLabsChromeWindows{

            @Override
            public WebDriver createInstance() throws MalformedURLException {
                DesiredCapabilities capabilities = DesiredCapabilities.chrome();
                capabilities.setCapability("platform", Platform.VISTA);
                capabilities.setCapability("name", "Neo4j Web Testing");
                return WebdriverSauceLabsDriver.createDriver(capabilities);
            }
        }
        ,
        SauceLabsInternetExplorerWindows{

            @Override
            public WebDriver createInstance() throws MalformedURLException {
                DesiredCapabilities capabilities = DesiredCapabilities.internetExplorer();
                capabilities.setCapability("platform", Platform.VISTA);
                capabilities.setCapability("name", "Neo4j Web Testing");
                return WebdriverSauceLabsDriver.createDriver(capabilities);
            }
        };


        public abstract WebDriver createInstance() throws Exception;
    }
}

