/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.dbms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.kernel.logging.ConsoleLogger;
import org.neo4j.server.rest.dbms.AuthorizationFilter;
import org.neo4j.server.rest.dbms.AuthorizedRequestWrapper;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.security.auth.AuthenticationResult;

public class AuthorizationFilterTest {
    private final AuthManager authManager = (AuthManager)Mockito.mock(AuthManager.class);
    private final ConsoleLogger logger = (ConsoleLogger)Mockito.mock(ConsoleLogger.class);
    private final AuthorizationFilter filter = new AuthorizationFilter(this.authManager, this.logger);
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final HttpServletRequest servletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
    private final HttpServletResponse servletResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
    private final FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.servletResponse.getOutputStream()).thenReturn((Object)new ServletOutputStream(){

            public void write(int b) throws IOException {
                AuthorizationFilterTest.this.outputStream.write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException();
            }
        });
    }

    @Test
    public void shouldAllowOptionsRequests() throws Exception {
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"OPTIONS");
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)org.mockito.Matchers.same((Object)this.servletRequest), (ServletResponse)org.mockito.Matchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldWhitelistRoot() throws Exception {
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/");
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)org.mockito.Matchers.same((Object)this.servletRequest), (ServletResponse)org.mockito.Matchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldWhitelistBrowser() throws Exception {
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/browser/index.html");
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)org.mockito.Matchers.same((Object)this.servletRequest), (ServletResponse)org.mockito.Matchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldWhitelistWebadmin() throws Exception {
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/webadmin/index.html");
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)org.mockito.Matchers.same((Object)this.servletRequest), (ServletResponse)org.mockito.Matchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldRequireAuthorization() throws Exception {
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.AuthorizationFailed\""));
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"No authorization header supplied.\""));
    }

    @Test
    public void shouldRequireValidAuthorizationHeader() throws Exception {
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)"NOT A VALID VALUE");
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(400);
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Request.InvalidFormat\""));
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"Invalid Authorization header.\""));
    }

    @Test
    public void shouldNotAuthorizeInvalidCredentials() throws Exception {
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(Charsets.UTF_8));
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.servletRequest.getRemoteAddr()).thenReturn((Object)"remote_ip_address");
        Mockito.when((Object)this.authManager.authenticate("foo", "bar")).thenReturn((Object)AuthenticationResult.NOT_AUTHORIZED);
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((ConsoleLogger)Mockito.verify((Object)this.logger)).warn("Failed authentication attempt for '%s' from %s", new Object[]{"foo", "remote_ip_address"});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(401);
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.AuthorizationFailed\""));
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"Invalid username or password.\""));
    }

    @Test
    public void shouldAuthorizeWhenPasswordChangeRequiredForWhitelistedPath() throws Exception {
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(Charsets.UTF_8));
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/user/foo");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.authenticate("foo", "bar")).thenReturn((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)org.mockito.Matchers.eq((Object)new AuthorizedRequestWrapper("BASIC", "foo", this.servletRequest)), (ServletResponse)org.mockito.Matchers.same((Object)this.servletResponse));
    }

    @Test
    public void shouldNotAuthorizeWhenPasswordChangeRequired() throws Exception {
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(Charsets.UTF_8));
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getRequestURL()).thenReturn((Object)new StringBuffer("http://bar.baz:7474/db/data/"));
        Mockito.when((Object)this.servletRequest.getRequestURI()).thenReturn((Object)"/db/data/");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.authenticate("foo", "bar")).thenReturn((Object)AuthenticationResult.PASSWORD_CHANGE_REQUIRED);
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(403);
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"password_change\" : \"http://bar.baz:7474/user/foo/password\""));
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.AuthorizationFailed\""));
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"User is required to change their password.\""));
    }

    @Test
    public void shouldNotAuthorizeWhenTooManyAttemptsMade() throws Exception {
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(Charsets.UTF_8));
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.authenticate("foo", "bar")).thenReturn((Object)AuthenticationResult.TOO_MANY_ATTEMPTS);
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChain});
        ((HttpServletResponse)Mockito.verify((Object)this.servletResponse)).setStatus(429);
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"code\" : \"Neo.ClientError.Security.AuthenticationRateLimit\""));
        Assert.assertThat((Object)this.outputStream.toString(Charsets.UTF_8.name()), (Matcher)Matchers.containsString((String)"\"message\" : \"Too many failed authentication requests. Please wait 5 seconds and try again.\""));
    }

    @Test
    public void shouldAuthorizeWhenValidCredentialsSupplied() throws Exception {
        String credentials = Base64.encodeBase64String((byte[])"foo:bar".getBytes(Charsets.UTF_8));
        Mockito.when((Object)this.servletRequest.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)this.servletRequest.getContextPath()).thenReturn((Object)"/db/data");
        Mockito.when((Object)this.servletRequest.getHeader("Authorization")).thenReturn((Object)("BASIC " + credentials));
        Mockito.when((Object)this.authManager.authenticate("foo", "bar")).thenReturn((Object)AuthenticationResult.SUCCESS);
        this.filter.doFilter((ServletRequest)this.servletRequest, (ServletResponse)this.servletResponse, this.filterChain);
        ((FilterChain)Mockito.verify((Object)this.filterChain)).doFilter((ServletRequest)org.mockito.Matchers.eq((Object)new AuthorizedRequestWrapper("BASIC", "foo", this.servletRequest)), (ServletResponse)org.mockito.Matchers.same((Object)this.servletResponse));
    }
}

