/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.server.ServerTestUtils;

public class DatabaseTuningPropertyFileBuilder {
    private File parentDirectory = null;
    private String mappedMemory = null;

    public static DatabaseTuningPropertyFileBuilder builder(File directory) {
        return new DatabaseTuningPropertyFileBuilder(directory);
    }

    private DatabaseTuningPropertyFileBuilder(File directory) {
        this.parentDirectory = directory;
    }

    public File build() throws IOException {
        File temporaryConfigFile = new File(this.parentDirectory, "neo4j.properties");
        Map properties = MapUtil.stringMap((String[])new String[]{"neostore.relationshipstore.db.mapped_memory", "50M", "neostore.propertystore.db.mapped_memory", "90M", "neostore.propertystore.db.strings.mapped_memory", "130M", "neostore.propertystore.db.arrays.mapped_memory", "150M"});
        if (this.mappedMemory == null) {
            properties.put("neostore.nodestore.db.mapped_memory", "25M");
        } else {
            properties.put("neostore.nodestore.db.mapped_memory", this.mappedMemory);
        }
        ServerTestUtils.writePropertiesToFile(properties, temporaryConfigFile);
        return temporaryConfigFile;
    }

    public DatabaseTuningPropertyFileBuilder mappedMemory(int i) {
        this.mappedMemory = String.valueOf(i) + "M";
        return this;
    }
}

