/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;

public class ConfiguratorWrappingConfigurationBuilderTest {
    @Test
    public void shouldGetNewPropertyValuesFromConfiguratorWrappingBuilder() throws Exception {
        Configurator.Adapter configurator = new Configurator.Adapter(){

            public Configuration configuration() {
                HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
                properties.put(ServerSettings.http_logging_enabled.name(), new Boolean(true));
                return new MapConfiguration(properties);
            }

            public List<ThirdPartyJaxRsPackage> getThirdpartyJaxRsPackages() {
                ArrayList<ThirdPartyJaxRsPackage> list = new ArrayList<ThirdPartyJaxRsPackage>();
                list.add(new ThirdPartyJaxRsPackage("lala", "sasa"));
                return list;
            }
        };
        ConfigurationBuilder.ConfiguratorWrappingConfigurationBuilder builder = new ConfigurationBuilder.ConfiguratorWrappingConfigurationBuilder((Configurator)configurator);
        Assert.assertTrue((boolean)((Boolean)builder.configuration().get(ServerSettings.http_logging_enabled)));
        Assert.assertEquals((long)1L, (long)((List)builder.configuration().get(ServerSettings.third_party_packages)).size());
    }
}

