/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.server.rest.domain.URIHelper;

public class IndexNodeDocIT
extends AbstractRestFunctionalTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() {
        functionalTestHelper = new FunctionalTestHelper(IndexNodeDocIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Before
    public void cleanTheDatabase() {
        this.cleanDatabase();
        this.gen().setGraph((GraphDatabaseService)IndexNodeDocIT.server().getDatabase().getGraph());
    }

    long createNode() {
        GraphDatabaseAPI graphdb = IndexNodeDocIT.server().getDatabase().getGraph();
        try (Transaction tx = graphdb.beginTx();){
            Node node = graphdb.createNode();
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    @Documented(value=" List node indexes.\n")
    @Test
    public void shouldGetListOfNodeIndexesWhenOneExist() throws JsonParseException {
        String indexName = "favorites";
        helper.createNodeIndex(indexName);
        String entity = this.gen().noGraph().expectedStatus(200).get(functionalTestHelper.nodeIndexUri()).entity();
        Map map = JsonHelper.jsonToMap((String)entity);
        Assert.assertNotNull(map.get(indexName));
        Assert.assertEquals((String)("Was: " + map + ", no-auto-index:" + functionalTestHelper.removeAnyAutoIndex(map)), (long)1L, (long)functionalTestHelper.removeAnyAutoIndex(map).size());
    }

    @Documented(value=" Create node index\n\n NOTE: Instead of creating the index this way, you can simply start to use\n it, and it will be created automatically with default configuration.\n")
    @Test
    public void shouldCreateANamedNodeIndex() {
        String indexName = "favorites";
        int expectedIndexes = helper.getNodeIndexes().length + 1;
        HashMap<String, String> indexSpecification = new HashMap<String, String>();
        indexSpecification.put("name", indexName);
        this.gen().noGraph().payload(JsonHelper.createJsonFrom(indexSpecification)).expectedStatus(201).expectedHeader("Location").post(functionalTestHelper.nodeIndexUri());
        Assert.assertEquals((long)expectedIndexes, (long)helper.getNodeIndexes().length);
        Assert.assertThat((Object)helper.getNodeIndexes(), FunctionalTestHelper.arrayContains(indexName));
    }

    @Test
    public void shouldCreateANamedNodeIndexWithSpaces() {
        String indexName = "favorites with spaces";
        int expectedIndexes = helper.getNodeIndexes().length + 1;
        HashMap<String, String> indexSpecification = new HashMap<String, String>();
        indexSpecification.put("name", indexName);
        this.gen().payload(JsonHelper.createJsonFrom(indexSpecification)).expectedStatus(201).expectedHeader("Location").post(functionalTestHelper.nodeIndexUri());
        Assert.assertEquals((long)expectedIndexes, (long)helper.getNodeIndexes().length);
        Assert.assertThat((Object)helper.getNodeIndexes(), FunctionalTestHelper.arrayContains(indexName));
    }

    @Documented(value=" Create node index with configuration. This request is only necessary if\n you want to customize the index settings. If you are happy with the\n defaults, you can just start indexing nodes/relationships, as\n non-existent indexes will automatically be created as you do. See\n <<indexing-create-advanced>> for more information on index configuration.\n")
    @Test
    public void shouldCreateANamedNodeIndexWithConfiguration() throws Exception {
        int expectedIndexes = helper.getNodeIndexes().length + 1;
        this.gen().noGraph().payload("{\"name\":\"fulltext\", \"config\":{\"type\":\"fulltext\",\"provider\":\"lucene\"}}").expectedStatus(201).expectedHeader("Location").post(functionalTestHelper.nodeIndexUri());
        Assert.assertEquals((long)expectedIndexes, (long)helper.getNodeIndexes().length);
        Assert.assertThat((Object)helper.getNodeIndexes(), FunctionalTestHelper.arrayContains("fulltext"));
    }

    @Documented(value=" Add node to index.\n \n Associates a node with the given key/value pair in the given index.\n \n NOTE: Spaces in the URI have to be encoded as +%20+.\n \n CAUTION: This does *not* overwrite previous entries. If you index the\n same key/value/item combination twice, two index entries are created. To\n do update-type operations, you need to delete the old entry before adding\n a new one.\n")
    @Test
    public void shouldAddToIndex() throws Exception {
        String indexName = "favorites";
        String key = "some-key";
        String value = "some value";
        long nodeId = this.createNode();
        this.gen().noGraph().expectedStatus(201).payload(JsonHelper.createJsonFrom((Object)this.generateNodeIndexCreationPayload("some-key", "some value", functionalTestHelper.nodeUri(nodeId)))).post(functionalTestHelper.indexNodeUri("favorites"));
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexNodeUri("favorites", "some-key", URIHelper.encode((String)"some value")));
        String entity = response.getEntity();
        Collection hits = (Collection)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)1L, (long)hits.size());
    }

    private Object generateNodeIndexCreationPayload(String key, String value, String nodeUri) {
        HashMap<String, String> results = new HashMap<String, String>();
        results.put("key", key);
        results.put("value", value);
        results.put("uri", nodeUri);
        return results;
    }

    @Documented(value=" Find node by exact match.\n \n NOTE: Spaces in the URI have to be encoded as +%20+.\n")
    @Test
    public void shouldAddToIndexAndRetrieveItByExactMatch() throws Exception {
        String indexName = "favorites";
        String key = "key";
        String value = "the value";
        long nodeId = this.createNode();
        value = URIHelper.encode((String)value);
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.indexNodeUri(indexName), this.createJsonStringFor(nodeId, key, value));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        String entity = this.gen().noGraph().expectedStatus(200).get(functionalTestHelper.indexNodeUri(indexName, key, URIHelper.encode((String)value))).entity();
        Collection hits = (Collection)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)1L, (long)hits.size());
    }

    @Documented(value=" Find node by query.\n \n The query language used here depends on what type of index you are\n querying. The default index type is Lucene, in which case you should use\n the Lucene query language here. Below an example of a fuzzy search over\n multiple keys.\n \n See: {lucene-base-uri}/queryparsersyntax.html\n \n Getting the results with a predefined ordering requires adding the\n parameter\n \n `order=ordering`\n \n where ordering is one of index, relevance or score. In this case an\n additional field will be added to each result, named score, that holds\n the float value that is the score reported by the query result.\n")
    @Test
    public void shouldAddToIndexAndRetrieveItByQuery() throws JsonParseException {
        String indexName = "bobTheIndex";
        String key = "Name";
        String value = "Builder";
        long node = helper.createNode(MapUtil.map((Object[])new Object[]{key, value}), new Label[0]);
        helper.addNodeToIndex(indexName, key, value, node);
        helper.addNodeToIndex(indexName, "Gender", "Male", node);
        String entity = this.gen().noGraph().expectedStatus(200).get(functionalTestHelper.indexNodeUri(indexName) + "?query=Name:Build~0.1%20AND%20Gender:Male").entity();
        Collection hits = (Collection)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)1L, (long)hits.size());
        LinkedHashMap nodeMap = (LinkedHashMap)hits.iterator().next();
        Assert.assertNull((String)"score should not be present when not explicitly ordering", nodeMap.get("score"));
    }

    @Test
    public void orderedResultsAreSupersetOfUnordered() throws Exception {
        String indexName = "bobTheIndex";
        String key = "Name";
        String value = "Builder";
        long node = helper.createNode(MapUtil.map((Object[])new Object[]{key, value}), new Label[0]);
        helper.addNodeToIndex(indexName, key, value, node);
        helper.addNodeToIndex(indexName, "Gender", "Male", node);
        String entity = this.gen().expectedStatus(200).get(functionalTestHelper.indexNodeUri(indexName) + "?query=Name:Build~0.1%20AND%20Gender:Male").entity();
        Collection hits = (Collection)JsonHelper.readJson((String)entity);
        LinkedHashMap nodeMapUnordered = (LinkedHashMap)hits.iterator().next();
        entity = this.gen().expectedStatus(200).get(functionalTestHelper.indexNodeUri(indexName) + "?query=Name:Build~0.1%20AND%20Gender:Male&order=score").entity();
        hits = (Collection)JsonHelper.readJson((String)entity);
        LinkedHashMap nodeMapOrdered = (LinkedHashMap)hits.iterator().next();
        for (Map.Entry unorderedEntry : nodeMapUnordered.entrySet()) {
            Assert.assertEquals((String)("wrong entry for key: " + (String)unorderedEntry.getKey()), unorderedEntry.getValue(), nodeMapOrdered.get(unorderedEntry.getKey()));
        }
        Assert.assertTrue((String)"There should be only one extra value for the ordered map", (nodeMapOrdered.size() == nodeMapUnordered.size() + 1 ? 1 : 0) != 0);
    }

    @Test
    public void shouldAddToIndexAndRetrieveItByQuerySorted() throws JsonParseException {
        String indexName = "bobTheIndex";
        String key = "Name";
        long node1 = helper.createNode(new Label[0]);
        long node2 = helper.createNode(new Label[0]);
        helper.addNodeToIndex(indexName, key, "Builder2", node1);
        helper.addNodeToIndex(indexName, "Gender", "Male", node1);
        helper.addNodeToIndex(indexName, key, "Builder", node2);
        helper.addNodeToIndex(indexName, "Gender", "Male", node2);
        String entity = this.gen().expectedStatus(200).get(functionalTestHelper.indexNodeUri(indexName) + "?query=Name:Build~0.1%20AND%20Gender:Male&order=relevance").entity();
        Collection hits = (Collection)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)2L, (long)hits.size());
        Iterator it = hits.iterator();
        LinkedHashMap node2Map = (LinkedHashMap)it.next();
        LinkedHashMap node1Map = (LinkedHashMap)it.next();
        float score2 = ((Double)node2Map.get("score")).floatValue();
        float score1 = ((Double)node1Map.get("score")).floatValue();
        Assert.assertTrue((String)"results returned in wrong order for relevance ordering", (boolean)((String)node2Map.get("self")).endsWith(Long.toString(node2)));
        Assert.assertTrue((String)"results returned in wrong order for relevance ordering", (boolean)((String)node1Map.get("self")).endsWith(Long.toString(node1)));
        Assert.assertTrue((String)"scores are reversed", (score2 > score1 ? 1 : 0) != 0);
        entity = this.gen().expectedStatus(200).get(functionalTestHelper.indexNodeUri(indexName) + "?query=Name:Build~0.1%20AND%20Gender:Male&order=index").entity();
        hits = (Collection)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)2L, (long)hits.size());
        it = hits.iterator();
        node1Map = (LinkedHashMap)it.next();
        node2Map = (LinkedHashMap)it.next();
        score1 = ((Double)node1Map.get("score")).floatValue();
        score2 = ((Double)node2Map.get("score")).floatValue();
        Assert.assertTrue((String)"results returned in wrong order for index ordering", (boolean)((String)node1Map.get("self")).endsWith(Long.toString(node1)));
        Assert.assertTrue((String)"results returned in wrong order for index ordering", (boolean)((String)node2Map.get("self")).endsWith(Long.toString(node2)));
        Assert.assertTrue((String)"scores are reversed", (score2 > score1 ? 1 : 0) != 0);
        entity = this.gen().expectedStatus(200).get(functionalTestHelper.indexNodeUri(indexName) + "?query=Name:Build~0.1%20AND%20Gender:Male&order=score").entity();
        hits = (Collection)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)2L, (long)hits.size());
        it = hits.iterator();
        node2Map = (LinkedHashMap)it.next();
        node1Map = (LinkedHashMap)it.next();
        score2 = ((Double)node2Map.get("score")).floatValue();
        score1 = ((Double)node1Map.get("score")).floatValue();
        Assert.assertTrue((String)"results returned in wrong order for score ordering", (boolean)((String)node2Map.get("self")).endsWith(Long.toString(node2)));
        Assert.assertTrue((String)"results returned in wrong order for score ordering", (boolean)((String)node1Map.get("self")).endsWith(Long.toString(node1)));
        Assert.assertTrue((String)"scores are reversed", (score2 > score1 ? 1 : 0) != 0);
    }

    @Test
    public void shouldRespondWith201CreatedWhenIndexingJsonNodeUri() {
        long nodeId = helper.createNode(new Label[0]);
        String key = "key";
        String value = "value";
        String indexName = "testy";
        helper.createNodeIndex("testy");
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.indexNodeUri("testy"), this.createJsonStringFor(nodeId, "key", "value"));
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertNotNull((Object)response.getHeaders().getFirst((Object)"Location"));
        Assert.assertEquals(Arrays.asList(nodeId), helper.getIndexedNodes("testy", "key", "value"));
    }

    @Test
    public void shouldGetNodeRepresentationFromIndexUri() throws JsonParseException {
        long nodeId = helper.createNode(new Label[0]);
        String key = "key2";
        String value = "value";
        String indexName = "mindex";
        helper.createNodeIndex(indexName);
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.indexNodeUri(indexName), this.createJsonStringFor(nodeId, key, value));
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        String indexUri = (String)response.getHeaders().getFirst((Object)"Location");
        response = RestRequest.req().get(indexUri);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String entity = response.getEntity();
        Map map = JsonHelper.jsonToMap((String)entity);
        Assert.assertNotNull(map.get("self"));
    }

    @Test
    public void shouldGet404WhenRequestingIndexUriWhichDoesntExist() {
        String key = "key3";
        String value = "value";
        String indexName = "nosuchindex";
        String indexUri = functionalTestHelper.nodeIndexUri() + indexName + "/" + key + "/" + value;
        JaxRsResponse response = RestRequest.req().get(indexUri);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet404WhenDeletingNonExtistentIndex() {
        String indexName = "nosuchindex";
        String indexUri = functionalTestHelper.nodeIndexUri() + indexName;
        JaxRsResponse response = RestRequest.req().delete(indexUri);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldGet200AndArrayOfNodeRepsWhenGettingFromIndex() throws JsonParseException {
        String key = "myKey";
        String value = "myValue";
        String name1 = "Thomas Anderson";
        String name2 = "Agent Smith";
        String indexName = "matrix";
        RestRequest request = RestRequest.req();
        JaxRsResponse responseToPost = request.post(functionalTestHelper.nodeUri(), "{\"name\":\"" + name1 + "\"}");
        Assert.assertEquals((long)201L, (long)responseToPost.getStatus());
        String location1 = (String)responseToPost.getHeaders().getFirst((Object)"Location");
        responseToPost.close();
        responseToPost = request.post(functionalTestHelper.nodeUri(), "{\"name\":\"" + name2 + "\"}");
        Assert.assertEquals((long)201L, (long)responseToPost.getStatus());
        String location2 = (String)responseToPost.getHeaders().getFirst((Object)"Location");
        responseToPost.close();
        responseToPost = request.post(functionalTestHelper.indexNodeUri(indexName), this.createJsonStringFor(functionalTestHelper.getNodeIdFromUri(location1), key, value));
        Assert.assertEquals((long)201L, (long)responseToPost.getStatus());
        String indexLocation1 = (String)responseToPost.getHeaders().getFirst((Object)"Location");
        responseToPost.close();
        responseToPost = request.post(functionalTestHelper.indexNodeUri(indexName), this.createJsonStringFor(functionalTestHelper.getNodeIdFromUri(location2), key, value));
        Assert.assertEquals((long)201L, (long)responseToPost.getStatus());
        String indexLocation2 = (String)responseToPost.getHeaders().getFirst((Object)"Location");
        HashMap<String, String> uriToName = new HashMap<String, String>();
        uriToName.put(indexLocation1, name1);
        uriToName.put(indexLocation2, name2);
        responseToPost.close();
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexNodeUri(indexName, key, value));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Collection items = (Collection)JsonHelper.readJson((String)response.getEntity());
        int counter = 0;
        for (Object item : items) {
            Map map = (Map)item;
            Map properties = (Map)map.get("data");
            Assert.assertNotNull(map.get("self"));
            String indexedUri = (String)map.get("indexed");
            Assert.assertEquals(uriToName.get(indexedUri), properties.get("name"));
            ++counter;
        }
        Assert.assertEquals((long)2L, (long)counter);
        response.close();
    }

    @Test
    public void shouldGet200WhenGettingNodesFromIndexWithNoHits() {
        String indexName = "empty-index";
        helper.createNodeIndex(indexName);
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexNodeUri(indexName, "non-existent-key", "non-existent-value"));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response.close();
    }

    @Documented(value=" Delete node index.\n")
    @Test
    public void shouldReturn204WhenRemovingNodeIndexes() {
        String indexName = "kvnode";
        helper.createNodeIndex(indexName);
        this.gen().noGraph().expectedStatus(204).delete(functionalTestHelper.indexNodeUri(indexName));
    }

    @Documented(value=" Remove all entries with a given node from an index.\n")
    @Test
    public void shouldBeAbleToRemoveIndexingById() {
        String key1 = "kvkey1";
        String key2 = "kvkey2";
        String value1 = "value1";
        String value2 = "value2";
        String indexName = "kvnode";
        long node = helper.createNode(MapUtil.map((Object[])new Object[]{key1, value1, key1, value2, key2, value1, key2, value2}), new Label[0]);
        helper.addNodeToIndex(indexName, key1, value1, node);
        helper.addNodeToIndex(indexName, key1, value2, node);
        helper.addNodeToIndex(indexName, key2, value1, node);
        helper.addNodeToIndex(indexName, key2, value2, node);
        this.gen().noGraph().expectedStatus(204).delete(functionalTestHelper.indexNodeUri(indexName) + "/" + node);
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes(indexName, key1, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes(indexName, key1, value2).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes(indexName, key2, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes(indexName, key2, value2).size());
    }

    @Documented(value=" Remove all entries with a given node and key from an index.\n")
    @Test
    public void shouldBeAbleToRemoveIndexingByIdAndKey() {
        String key1 = "kvkey1";
        String key2 = "kvkey2";
        String value1 = "value1";
        String value2 = "value2";
        String indexName = "kvnode";
        long node = helper.createNode(MapUtil.map((Object[])new Object[]{key1, value1, key1, value2, key2, value1, key2, value2}), new Label[0]);
        helper.addNodeToIndex(indexName, key1, value1, node);
        helper.addNodeToIndex(indexName, key1, value2, node);
        helper.addNodeToIndex(indexName, key2, value1, node);
        helper.addNodeToIndex(indexName, key2, value2, node);
        this.gen().noGraph().expectedStatus(204).delete(functionalTestHelper.nodeIndexUri() + indexName + "/" + key2 + "/" + node);
        Assert.assertEquals((long)1L, (long)helper.getIndexedNodes(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedNodes(indexName, key1, value2).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes(indexName, key2, value1).size());
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes(indexName, key2, value2).size());
    }

    @Documented(value=" Remove all entries with a given node, key and value from an index.\n")
    @Test
    public void shouldBeAbleToRemoveIndexingByIdAndKeyAndValue() {
        String key1 = "kvkey1";
        String key2 = "kvkey2";
        String value1 = "value1";
        String value2 = "value2";
        String indexName = "kvnode";
        long node = helper.createNode(MapUtil.map((Object[])new Object[]{key1, value1, key1, value2, key2, value1, key2, value2}), new Label[0]);
        helper.addNodeToIndex(indexName, key1, value1, node);
        helper.addNodeToIndex(indexName, key1, value2, node);
        helper.addNodeToIndex(indexName, key2, value1, node);
        helper.addNodeToIndex(indexName, key2, value2, node);
        this.gen().noGraph().expectedStatus(204).delete(functionalTestHelper.nodeIndexUri() + indexName + "/" + key1 + "/" + value1 + "/" + node);
        Assert.assertEquals((long)0L, (long)helper.getIndexedNodes(indexName, key1, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedNodes(indexName, key1, value2).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedNodes(indexName, key2, value1).size());
        Assert.assertEquals((long)1L, (long)helper.getIndexedNodes(indexName, key2, value2).size());
    }

    @Test
    public void shouldBeAbleToIndexValuesContainingSpaces() throws Exception {
        long nodeId = helper.createNode(new Label[0]);
        String key = "key";
        String value = "value with   spaces  in it";
        String indexName = "spacey-values";
        helper.createNodeIndex(indexName);
        RestRequest request = RestRequest.req();
        JaxRsResponse response = request.post(functionalTestHelper.indexNodeUri(indexName), this.createJsonStringFor(nodeId, "key", "value with   spaces  in it"));
        Assert.assertEquals((long)Response.Status.CREATED.getStatusCode(), (long)response.getStatus());
        URI location = response.getLocation();
        response.close();
        response = request.get(functionalTestHelper.indexNodeUri(indexName, "key", URIHelper.encode((String)"value with   spaces  in it")));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Collection hits = (Collection)JsonHelper.readJson((String)response.getEntity());
        Assert.assertEquals((long)1L, (long)hits.size());
        response.close();
        FunctionalTestHelper.CLIENT.resource(location).delete();
        response = request.get(functionalTestHelper.indexNodeUri(indexName, "key", URIHelper.encode((String)"value with   spaces  in it")));
        hits = (Collection)JsonHelper.readJson((String)response.getEntity());
        Assert.assertEquals((long)0L, (long)hits.size());
    }

    private String createJsonStringFor(long nodeId, String key, String value) {
        return "{\"key\": \"" + key + "\", \"value\": \"" + value + "\", \"uri\": \"" + functionalTestHelper.nodeUri(nodeId) + "\"}";
    }

    @Test
    public void shouldRespondWith400WhenSendingCorruptJson() throws Exception {
        String indexName = "botherable-index";
        helper.createNodeIndex("botherable-index");
        String corruptJson = "{\"key\" \"myKey\"}";
        JaxRsResponse response = RestRequest.req().post(functionalTestHelper.indexNodeUri("botherable-index"), "{\"key\" \"myKey\"}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
        response.close();
    }

    @Documented(value=" Get or create unique node (create).\n \n The node is created if it doesn't exist in the unique index already.\n")
    @Test
    public void get_or_create_a_node_in_an_unique_index() throws Exception {
        String index = "people";
        String key = "name";
        String value = "Tobias";
        helper.createNodeIndex("people");
        RESTDocsGenerator.ResponseEntity response = this.gen().noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Tobias\", \"properties\": {\"name\": \"Tobias\", \"sequence\": 1}}").post(functionalTestHelper.nodeIndexUri() + "people" + "?uniqueness=get_or_create");
        MultivaluedMap<String, String> headers = response.response().getHeaders();
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Assert.assertEquals(result.get("indexed"), (Object)headers.getFirst((Object)"Location"));
        Map data = IndexNodeDocIT.assertCast(Map.class, result.get("data"));
        Assert.assertEquals((Object)"Tobias", data.get("name"));
        Assert.assertEquals((Object)1, data.get("sequence"));
    }

    @Test
    public void get_or_create_node_with_array_properties() throws Exception {
        Node node;
        String index = "people";
        String key = "name";
        String value = "Tobias";
        helper.createNodeIndex("people");
        RESTDocsGenerator.ResponseEntity response = this.gen().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Tobias\", \"properties\": {\"name\": \"Tobias\", \"array\": [1,2,3]}}").post(functionalTestHelper.nodeIndexUri() + "people" + "?unique");
        MultivaluedMap<String, String> headers = response.response().getHeaders();
        Map result = JsonHelper.jsonToMap((String)response.entity());
        String location = (String)headers.getFirst((Object)"Location");
        Assert.assertEquals(result.get("indexed"), (Object)location);
        Map data = IndexNodeDocIT.assertCast(Map.class, result.get("data"));
        Assert.assertEquals((Object)"Tobias", data.get("name"));
        Assert.assertEquals(Arrays.asList(1, 2, 3), data.get("array"));
        try (Transaction tx = this.graphdb().beginTx();){
            node = (Node)this.graphdb().index().forNodes("people").get("name", (Object)"Tobias").getSingle();
        }
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"Tobias")));
        Assert.assertThat((Object)node, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)this.graphdb(), (Matcher)Neo4jMatchers.hasProperty((String)"array").withValue((Object)new int[]{1, 2, 3})));
    }

    @Documented(value=" Get or create unique node (existing).\n \n Here,\n a node is not created but the existing unique node returned, since another node\n is indexed with the same data already. The node data returned is then that of the\n already existing node.\n")
    @Test
    public void get_or_create_unique_node_if_already_existing() throws Exception {
        String index = "people";
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        try (Transaction tx = this.graphdb().beginTx();){
            Node peter = graphdb.createNode();
            peter.setProperty("name", (Object)"Peter");
            peter.setProperty("sequence", (Object)1);
            graphdb.index().forNodes("people").add((PropertyContainer)peter, "name", (Object)"Peter");
            tx.success();
        }
        helper.createNodeIndex("people");
        RESTDocsGenerator.ResponseEntity response = this.gen().noGraph().expectedStatus(200).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"properties\": {\"name\": \"Peter\", \"sequence\": 2}}").post(functionalTestHelper.nodeIndexUri() + "people" + "?uniqueness=get_or_create");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Map data = IndexNodeDocIT.assertCast(Map.class, result.get("data"));
        Assert.assertEquals((Object)"Peter", data.get("name"));
        Assert.assertEquals((Object)1, data.get("sequence"));
    }

    @Documented(value=" Create a unique node or return fail (create).\n \n Here, in case\n of an already existing node, an error should be returned. In this\n example, no existing indexed node is found and a new node is created.\n")
    @Test
    public void create_a_unique_node_or_fail_create() throws Exception {
        String index = "people";
        String key = "name";
        String value = "Tobias";
        helper.createNodeIndex("people");
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Tobias\", \"properties\": {\"name\": \"Tobias\", \"sequence\": 1}}").post(functionalTestHelper.nodeIndexUri() + "people" + "?uniqueness=create_or_fail");
        MultivaluedMap<String, String> headers = response.response().getHeaders();
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Assert.assertEquals(result.get("indexed"), (Object)headers.getFirst((Object)"Location"));
        Map data = IndexNodeDocIT.assertCast(Map.class, result.get("data"));
        Assert.assertEquals((Object)"Tobias", data.get("name"));
        Assert.assertEquals((Object)1, data.get("sequence"));
    }

    @Documented(value=" Create a unique node or return fail (fail).\n \n Here, in case\n of an already existing node, an error should be returned. In this\n example, an existing node indexed with the same data\n is found and an error is returned.\n")
    @Test
    public void create_a_unique_node_or_return_fail___fail() throws Exception {
        String index = "people";
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createNodeIndex("people");
        try (Transaction tx = graphdb.beginTx();){
            Node peter = graphdb.createNode();
            peter.setProperty("name", (Object)"Peter");
            peter.setProperty("sequence", (Object)1);
            graphdb.index().forNodes("people").add((PropertyContainer)peter, "name", (Object)"Peter");
            tx.success();
        }
        RestRequest.req();
        RESTDocsGenerator.ResponseEntity response = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(409).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"properties\": {\"name\": \"Peter\", \"sequence\": 2}}").post(functionalTestHelper.nodeIndexUri() + "people" + "?uniqueness=create_or_fail");
        Map result = JsonHelper.jsonToMap((String)response.entity());
        Map data = IndexNodeDocIT.assertCast(Map.class, result.get("data"));
        Assert.assertEquals((Object)"Peter", data.get("name"));
        Assert.assertEquals((Object)1, data.get("sequence"));
    }

    @Documented(value=" Add an existing node to unique index (not indexed).\n \n Associates a node with the given key/value pair in the given unique\n index.\n \n In this example, we are using `create_or_fail` uniqueness.\n")
    @Test
    public void addExistingNodeToUniqueIndexAdded() throws Exception {
        String indexName = "favorites";
        String key = "some-key";
        String value = "some value";
        long nodeId = this.createNode();
        this.gen().noGraph().expectedStatus(201).payload(JsonHelper.createJsonFrom((Object)this.generateNodeIndexCreationPayload("some-key", "some value", functionalTestHelper.nodeUri(nodeId)))).post(functionalTestHelper.indexNodeUri("favorites") + "?uniqueness=create_or_fail");
        JaxRsResponse response = RestRequest.req().get(functionalTestHelper.indexNodeUri("favorites", "some-key", URIHelper.encode((String)"some value")));
        String entity = response.getEntity();
        Collection hits = (Collection)JsonHelper.readJson((String)entity);
        Assert.assertEquals((long)1L, (long)hits.size());
    }

    @Documented(value=" Add an existing node to unique index (already indexed).\n \n In this case, the node already exists in the index, and thus we get a `HTTP 409` status response,\n as we have set the uniqueness to `create_or_fail`.\n \n")
    @Test
    public void addExistingNodeToUniqueIndexExisting() throws Exception {
        String indexName = "favorites";
        String key = "some-key";
        String value = "some value";
        try (Transaction tx = this.graphdb().beginTx();){
            Node peter = this.graphdb().createNode();
            peter.setProperty("some-key", (Object)"some value");
            this.graphdb().index().forNodes("favorites").add((PropertyContainer)peter, "some-key", (Object)"some value");
            tx.success();
        }
        this.gen().noGraph().expectedStatus(409).payload(JsonHelper.createJsonFrom((Object)this.generateNodeIndexCreationPayload("some-key", "some value", functionalTestHelper.nodeUri(this.createNode())))).post(functionalTestHelper.indexNodeUri("favorites") + "?uniqueness=create_or_fail");
    }

    @Documented(value=" Backward Compatibility Test (using old syntax ?unique)\n Put node if absent - Create.\n \n Add a node to an index unless a node already exists for the given index data. In\n this case, a new node is created since nothing existing is found in the index.\n")
    @Test
    public void put_node_if_absent___create() throws Exception {
        String index = "people";
        String key = "name";
        String value = "Mattias";
        helper.createNodeIndex("people");
        String uri = functionalTestHelper.nodeIndexUri() + "people" + "?unique";
        this.gen().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Mattias\", \"uri\":\"" + functionalTestHelper.nodeUri(helper.createNode(new Label[0])) + "\"}").post(uri);
    }

    @Test
    public void already_indexed_node_should_not_fail_on_create_or_fail() throws Exception {
        Node node;
        String index = "nodeIndex";
        String key = "name";
        String value = "Peter";
        GraphDatabaseService graphdb = this.graphdb();
        helper.createNodeIndex("nodeIndex");
        try (Transaction tx = graphdb.beginTx();){
            node = graphdb.createNode();
            graphdb.index().forNodes("nodeIndex").add((PropertyContainer)node, "name", (Object)"Peter");
            tx.success();
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(201).payloadType(MediaType.APPLICATION_JSON_TYPE).payload("{\"key\": \"name\", \"value\": \"Peter\", \"uri\":\"" + functionalTestHelper.nodeUri(node.getId()) + "\"}").post(functionalTestHelper.nodeIndexUri() + "nodeIndex" + "?uniqueness=create_or_fail");
    }

    private static <T> T assertCast(Class<T> type, Object object) {
        Assert.assertTrue((boolean)type.isInstance(object));
        return type.cast(object);
    }
}

