/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.util.Map;
import org.neo4j.kernel.logging.DefaultLogging;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.server.configuration.ConfigurationBuilder;

public abstract class LoggingFactory {
    public static final LoggingFactory DEFAULT_LOGGING = new LoggingFactory(){

        @Override
        public Logging create(ConfigurationBuilder configurator, Monitors monitors) {
            return DefaultLogging.createDefaultLogging((Map)configurator.getDatabaseTuningProperties(), (Monitors)monitors);
        }
    };
    public static final LoggingFactory IMPERMANENT_LOGGING = new LoggingFactory(){

        @Override
        public Logging create(ConfigurationBuilder configurator, Monitors monitors) {
            return DevNullLoggingService.DEV_NULL;
        }
    };

    public abstract Logging create(ConfigurationBuilder var1, Monitors var2);

    public static LoggingFactory given(final Logging logging) {
        return new LoggingFactory(){

            @Override
            public Logging create(ConfigurationBuilder configurator, Monitors monitors) {
                return logging;
            }
        };
    }
}

