/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.integration;

import javax.management.ObjectName;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class ServerConfigIT
extends ExclusiveServerTestBase {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();
    private CommunityNeoServer server;

    @Test
    public void serverConfigShouldBeVisibleInJMX() throws Throwable {
        String configValue = this.tempDir.newFile().getAbsolutePath();
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.http_log_config_File.name(), configValue).build();
        this.server.start();
        ObjectName name = JmxUtils.getObjectName((GraphDatabaseService)this.server.getDatabase().getGraph(), (String)"Configuration");
        MatcherAssert.assertThat((Object)JmxUtils.getAttribute((ObjectName)name, (String)ServerSettings.http_log_config_File.name()), (Matcher)Matchers.equalTo((Object)configValue));
    }

    @After
    public void cleanup() {
        this.server.stop();
    }
}

