/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.kernel.impl.recovery.TestStoreRecoverer;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestPerformRecoveryIfNecessary {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
    public String homeDirectory;
    public String storeDirectory;
    private static final String LINEBREAK = System.getProperty("line.separator");

    @Before
    public void createDirs() {
        this.homeDirectory = this.testDir.directory().getAbsolutePath();
        this.storeDirectory = new File(this.homeDirectory, "data" + File.separator + "graph.db").getAbsolutePath();
    }

    @Test
    public void shouldNotDoAnythingIfNoDBPresent() throws Exception {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Config config = this.buildProperties();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream), DevNullLoggingService.DEV_NULL);
        Assert.assertThat((String)"Recovery task runs successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"No database should have been created.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((String)"Recovery task should not print anything.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void doesNotPrintAnythingIfDatabaseWasCorrectlyShutdown() throws Exception {
        Config config = this.buildProperties();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDirectory).shutdown();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream), DevNullLoggingService.DEV_NULL);
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Recovery should not print anything.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)""));
    }

    @Test
    public void shouldPerformRecoveryIfNecessary() throws Exception {
        TestLogging logging = new TestLogging();
        StoreRecoverer recoverer = new StoreRecoverer();
        Config config = this.buildProperties();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDirectory).shutdown();
        TestStoreRecoverer.createLogFileForNextVersionWithSomeDataInIt((File)new File(this.storeDirectory), (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        Assert.assertThat((String)"Store should need recovery", (Object)recoverer.recoveryNeededAt(new File(this.storeDirectory)), (Matcher)CoreMatchers.is((Object)true));
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), new PrintStream(outputStream), (Logging)logging);
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Recovery should print status message.", (Object)outputStream.toString(), (Matcher)CoreMatchers.is((Object)("Detected incorrectly shut down database, performing recovery.." + LINEBREAK)));
        Assert.assertThat((String)"Store should be recovered", (Object)recoverer.recoveryNeededAt(new File(this.storeDirectory)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotPerformRecoveryIfNoNeostorePresent() throws Exception {
        new File(this.storeDirectory).mkdirs();
        new File(this.storeDirectory, "unrelated_file").createNewFile();
        boolean actual = new StoreRecoverer().recoveryNeededAt(new File(this.storeDirectory), 0L);
        Assert.assertThat((String)"Recovery should not be needed", (Object)actual, (Matcher)CoreMatchers.is((Object)false));
    }

    private Config buildProperties() throws IOException {
        FileUtils.deleteRecursively((File)new File(this.homeDirectory));
        new File(this.homeDirectory + "/conf").mkdirs();
        Properties databaseProperties = new Properties();
        String databasePropertiesFileName = this.homeDirectory + "/conf/neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        Config serverProperties = new Config(MapUtil.stringMap((String[])new String[]{Configurator.DATABASE_LOCATION_PROPERTY_KEY, this.storeDirectory, Configurator.DB_TUNING_PROPERTY_FILE_KEY, databasePropertiesFileName}));
        return serverProperties;
    }
}

