/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;

public class TraverserDocIT
extends AbstractRestFunctionalTestBase {
    @Test
    public void shouldGet404WhenTraversingFromNonExistentNode() {
        this.gen().expectedStatus(Response.Status.NOT_FOUND.getStatusCode()).payload("{}").post(this.getDataUri() + "node/10000/traverse/node").entity();
    }

    @Test
    @GraphDescription.Graph(nodes={@GraphDescription.NODE(name="I")})
    public void shouldGet200WhenNoHitsFromTraversing() {
        this.assertSize(0, this.gen().expectedStatus(200).payload("").post(this.getTraverseUriNodes(this.getNode("I"))).entity());
    }

    @Test
    @GraphDescription.Graph(value={"I know you", "I own car"})
    public void return_relationships_from_a_traversal() {
        this.assertSize(2, this.gen().expectedStatus(200).payload("{\"order\":\"breadth_first\",\"uniqueness\":\"none\",\"return_filter\":{\"language\":\"builtin\",\"name\":\"all\"}}").post(this.getTraverseUriRelationships(this.getNode("I"))).entity());
    }

    @Test
    @GraphDescription.Graph(value={"I know you", "I own car"})
    public void return_paths_from_a_traversal() {
        this.assertSize(3, this.gen().expectedStatus(200).payload("{\"order\":\"breadth_first\",\"uniqueness\":\"none\",\"return_filter\":{\"language\":\"builtin\",\"name\":\"all\"}}").post(this.getTraverseUriPaths(this.getNode("I"))).entity());
    }

    private String getTraverseUriRelationships(Node node) {
        return this.getNodeUri(node) + "/traverse/relationship";
    }

    private String getTraverseUriPaths(Node node) {
        return this.getNodeUri(node) + "/traverse/path";
    }

    private String getTraverseUriNodes(Node node) {
        return this.getNodeUri(node) + "/traverse/node";
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void shouldGetSomeHitsWhenTraversingWithDefaultDescription() throws JsonParseException {
        String entity = this.gen().expectedStatus(Response.Status.OK.getStatusCode()).payload("{}").post(this.getTraverseUriNodes(this.getNode("I"))).entity();
        this.expectNodes(entity, this.getNode("you"));
    }

    private void expectNodes(String entity, Node ... nodes) throws JsonParseException {
        HashSet<String> expected = new HashSet<String>();
        for (Node node : nodes) {
            expected.add(this.getNodeUri(node));
        }
        Collection items = (Collection)JsonHelper.readJson((String)entity);
        for (Object item : items) {
            Map map = (Map)item;
            String uri = (String)map.get("self");
            Assert.assertTrue((String)(uri + " not found"), (boolean)expected.remove(uri));
        }
        Assert.assertTrue((String)("Expected not empty:" + expected), (boolean)expected.isEmpty());
    }

    @Documented(value=" Traversal using a return filter.\n\n In this example, the +none+ prune evaluator is used and a return filter\n is supplied in order to return all names containing \"t\".\n The result is to be returned as nodes and the max depth is\n set to 3.\n")
    @GraphDescription.Graph(value={"Root knows Mattias", "Root knows Johan", "Johan knows Emil", "Emil knows Peter", "Emil knows Tobias", "Tobias loves Sara"})
    @Test
    public void shouldGetExpectedHitsWhenTraversingWithDescription() throws JsonParseException {
        Node start = this.getNode("Root");
        ArrayList<Map> rels = new ArrayList<Map>();
        rels.add(MapUtil.map((Object[])new Object[]{"type", "knows", "direction", "all"}));
        rels.add(MapUtil.map((Object[])new Object[]{"type", "loves", "direction", "all"}));
        String description = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"order", "breadth_first", "uniqueness", "node_global", "prune_evaluator", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "position.length() > 10"}), "return_filter", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "position.endNode().getProperty('name').toLowerCase().contains('t')"}), "relationships", rels, "max_depth", 3}));
        String entity = this.gen().expectedStatus(200).payload(description).post(this.getTraverseUriNodes(start)).entity();
        this.expectNodes(entity, this.getNodes("Root", "Mattias", "Peter", "Tobias"));
    }

    @Documented(value=" Traversal returning nodes below a certain depth.\n\n Here, all nodes at a traversal depth below 3 are returned.\n")
    @GraphDescription.Graph(value={"Root knows Mattias", "Root knows Johan", "Johan knows Emil", "Emil knows Peter", "Emil knows Tobias", "Tobias loves Sara"})
    @Test
    public void shouldGetExpectedHitsWhenTraversingAtDepth() throws JsonParseException {
        Node start = this.getNode("Root");
        String description = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"prune_evaluator", MapUtil.map((Object[])new Object[]{"language", "builtin", "name", "none"}), "return_filter", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "position.length()<3;"})}));
        String entity = this.gen().expectedStatus(200).payload(description).post(this.getTraverseUriNodes(start)).entity();
        this.expectNodes(entity, this.getNodes("Root", "Mattias", "Johan", "Emil"));
    }

    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void shouldGet400WhenSupplyingInvalidTraverserDescriptionFormat() {
        this.gen().expectedStatus(Response.Status.BAD_REQUEST.getStatusCode()).payload("::not JSON{[ at all").post(this.getTraverseUriNodes(this.getNode("I"))).entity();
    }

    @Test
    @GraphDescription.Graph(value={"Root knows Mattias", "Root knows Johan", "Johan knows Emil", "Emil knows Peter", "Root eats Cork", "Cork hates Root", "Root likes Banana", "Banana is_a Fruit"})
    public void shouldAllowTypeOrderedTraversals() throws JsonParseException {
        Node start = this.getNode("Root");
        String description = JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"expander", "order_by_type", "relationships", new Map[]{MapUtil.map((Object[])new Object[]{"type", "eats"}), MapUtil.map((Object[])new Object[]{"type", "knows"}), MapUtil.map((Object[])new Object[]{"type", "likes"})}, "prune_evaluator", MapUtil.map((Object[])new Object[]{"language", "builtin", "name", "none"}), "return_filter", MapUtil.map((Object[])new Object[]{"language", "javascript", "body", "position.length()<2;"})}));
        List nodes = (List)JsonHelper.readJson((String)this.gen().expectedStatus(200).payload(description).post(this.getTraverseUriNodes(start)).entity());
        Assert.assertThat((Object)nodes.size(), (Matcher)Matchers.is((Object)5));
        Assert.assertThat((Object)this.getName((Map)nodes.get(0)), (Matcher)Matchers.is((Object)"Root"));
        Assert.assertThat((Object)this.getName((Map)nodes.get(1)), (Matcher)Matchers.is((Object)"Cork"));
        HashSet<String> knowsNodes = new HashSet<String>(Arrays.asList("Johan", "Mattias"));
        Assert.assertTrue((boolean)knowsNodes.remove(this.getName((Map)nodes.get(2))));
        Assert.assertTrue((boolean)knowsNodes.remove(this.getName((Map)nodes.get(3))));
        Assert.assertThat((Object)this.getName((Map)nodes.get(4)), (Matcher)Matchers.is((Object)"Banana"));
    }

    private String getName(Map<String, Object> propContainer) {
        return (String)((Map)propContainer.get("data")).get("name");
    }
}

