/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.jmx.Primitives;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestData;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class WrappingNeoServerBootstrapperDocIT
extends ExclusiveServerTestBase {
    @Rule
    public TestData<RESTDocsGenerator> gen = TestData.producedThrough(RESTDocsGenerator.PRODUCER);
    static GraphDatabaseAPI myDb;

    @BeforeClass
    public static void setup() throws IOException {
        myDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
    }

    @AfterClass
    public static void teardown() {
        myDb.shutdown();
    }

    @Test
    public void usingWrappingNeoServerBootstrapper() {
        GraphDatabaseAPI graphdb = myDb;
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper(graphdb);
        srv.start();
        srv.stop();
    }

    @Test
    public void shouldAllowModifyingProperties() {
        GraphDatabaseAPI graphdb = (GraphDatabaseAPI)new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(TargetDirectory.forTest(this.getClass()).makeGraphDbDir().getAbsolutePath()).setConfig(ShellSettings.remote_shell_enabled, "true").newGraphDatabase();
        ServerConfigurator config = new ServerConfigurator(graphdb);
        config.configuration().setProperty(Configurator.WEBSERVER_PORT_PROPERTY_KEY, (Object)"7575");
        config.configuration().setProperty(ServerSettings.auth_enabled.name(), (Object)"false");
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper(graphdb, (Configurator)config);
        srv.start();
        Assert.assertEquals((long)srv.getServer().baseUri().getPort(), (long)7575L);
        String response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"command\" : \"ls\",\"engine\":\"shell\"}").expectedStatus(ClientResponse.Status.OK.getStatusCode()).post("http://127.0.0.1:7575/db/manage/server/console/").entity();
        Assert.assertTrue((boolean)response.contains("neo4j-sh (?)$"));
        srv.stop();
    }

    @Test
    public void shouldAllowShellConsoleWithoutCustomConfig() {
        ServerConfigurator config = new ServerConfigurator(myDb);
        config.configuration().setProperty(ServerSettings.auth_enabled.name(), (Object)"false");
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper(myDb, (Configurator)config);
        srv.start();
        String response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"command\" : \"ls\",\"engine\":\"shell\"}").expectedStatus(ClientResponse.Status.OK.getStatusCode()).post("http://127.0.0.1:7474/db/manage/server/console/").entity();
        Assert.assertTrue((boolean)response.contains("neo4j-sh (?)$"));
        srv.stop();
    }

    @Test
    public void shouldAllowModifyingListenPorts() throws UnknownHostException {
        ServerConfigurator config = new ServerConfigurator(myDb);
        String hostAddress = InetAddress.getLocalHost().getHostAddress();
        config.configuration().setProperty(Configurator.WEBSERVER_ADDRESS_PROPERTY_KEY, (Object)hostAddress.toString());
        config.configuration().setProperty(ServerSettings.auth_enabled.name(), (Object)"false");
        config.configuration().setProperty(Configurator.WEBSERVER_PORT_PROPERTY_KEY, (Object)"8484");
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper(myDb, (Configurator)config);
        srv.start();
        try {
            ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.OK.getStatusCode()).get(String.format("http://%s:7474/db/data/", hostAddress));
            Assert.fail();
        }
        catch (ClientHandlerException clientHandlerException) {
            // empty catch block
        }
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.OK.getStatusCode()).get("http://" + hostAddress + ":8484/db/data/");
        srv.stop();
    }

    @Test
    public void shouldRespondAndBeAbleToModifyDb() {
        ServerConfigurator configurator = new ServerConfigurator(myDb);
        configurator.configuration().setProperty(ServerSettings.auth_enabled.name(), (Object)"false");
        WrappingNeoServerBootstrapper srv = new WrappingNeoServerBootstrapper(myDb, (Configurator)configurator);
        srv.start();
        long originalNodeNumber = ((Primitives)((JmxKernelExtension)myDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Primitives.class)).getNumberOfNodeIdsInUse();
        FunctionalTestHelper helper = new FunctionalTestHelper(srv.getServer());
        JaxRsResponse response = new RestRequest().get(helper.dataUri());
        Assert.assertEquals((long)200L, (long)response.getStatus());
        String nodeData = "{\"age\":12}";
        response = new RestRequest().post(helper.dataUri() + "node", nodeData);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        long newNodeNumber = ((Primitives)((JmxKernelExtension)myDb.getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Primitives.class)).getNumberOfNodeIdsInUse();
        Assert.assertEquals((long)(originalNodeNumber + 1L), (long)newNodeNumber);
        srv.stop();
        try (Transaction tx = myDb.beginTx();){
            Assert.assertTrue((myDb.createNode() != null ? 1 : 0) != 0);
        }
    }
}

