/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.GraphDescription;

public class SchemaIndexDocIT
extends AbstractRestFunctionalTestBase {
    @Before
    public void setup() {
        this.cleanDatabase();
    }

    @Documented(value=" Create index.\n\n This will start a background job in the database that will create and populate the index.\n You can check the status of your index by listing all the indexes for the relevant label.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void create_index() throws JsonParseException {
        this.data.get();
        String labelName = "person";
        String propertyKey = "name";
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList(propertyKey)});
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri(labelName)).entity();
        Map serialized = JsonHelper.jsonToMap((String)result);
        Assert.assertEquals((Object)labelName, serialized.get("label"));
        Assert.assertEquals(Arrays.asList(propertyKey), serialized.get("property_keys"));
    }

    @Documented(value=" List indexes for a label.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_indexes_for_label() throws JsonParseException {
        this.data.get();
        String labelName = "user";
        String propertyKey = "name";
        this.createIndex(labelName, propertyKey);
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList(propertyKey)});
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).payload(JsonHelper.createJsonFrom((Object)definition)).get(this.getSchemaIndexLabelUri(labelName)).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        Assert.assertEquals((long)1L, (long)serializedList.size());
        Map serialized = (Map)serializedList.get(0);
        Assert.assertEquals((Object)labelName, serialized.get("label"));
        Assert.assertEquals(Arrays.asList(propertyKey), serialized.get("property_keys"));
    }

    @Documented(value=" Get all indexes.\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void get_indexes() throws JsonParseException {
        this.data.get();
        String labelName1 = "user";
        String propertyKey1 = "name1";
        String labelName2 = "prog";
        String propertyKey2 = "name2";
        this.createIndex(labelName1, propertyKey1);
        this.createIndex(labelName2, propertyKey2);
        String result = ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(200).get(this.getSchemaIndexUri()).entity();
        List serializedList = JsonHelper.jsonToList((String)result);
        Assert.assertEquals((long)2L, (long)serializedList.size());
        HashSet<String> labelNames = new HashSet<String>();
        HashSet<List> propertyKeys = new HashSet<List>();
        Map serialized1 = (Map)serializedList.get(0);
        labelNames.add((String)serialized1.get("label"));
        propertyKeys.add((List)serialized1.get("property_keys"));
        Map serialized2 = (Map)serializedList.get(1);
        labelNames.add((String)serialized2.get("label"));
        propertyKeys.add((List)serialized2.get("property_keys"));
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new String[]{labelName1, labelName2}), labelNames);
        Assert.assertEquals((Object)IteratorUtil.asSet((Object[])new List[]{Arrays.asList(propertyKey1), Arrays.asList(propertyKey2)}), propertyKeys);
    }

    @Documented(value=" Drop index\n")
    @Test
    @GraphDescription.Graph(nodes={})
    public void drop_index() throws Exception {
        this.data.get();
        String labelName = "SomeLabel";
        String propertyKey = "name";
        IndexDefinition schemaIndex = this.createIndex(labelName, propertyKey);
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.graphdb(), (Label)DynamicLabel.label((String)labelName)), (Matcher)Neo4jMatchers.containsOnly((Object[])new IndexDefinition[]{schemaIndex}));
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(204).delete(this.getSchemaIndexLabelPropertyUri(labelName, propertyKey)).entity();
        Assert.assertThat((Object)Neo4jMatchers.getIndexes((GraphDatabaseService)this.graphdb(), (Label)DynamicLabel.label((String)labelName)), (Matcher)IsNot.not((Matcher)Neo4jMatchers.containsOnly((Object[])new IndexDefinition[]{schemaIndex})));
    }

    @Test
    public void create_existing_index() {
        String labelName = "mylabel";
        String propertyKey = "name";
        this.createIndex(labelName, propertyKey);
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList(propertyKey)});
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(409).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri(labelName));
    }

    @Test
    public void drop_non_existent_index() throws Exception {
        String labelName = "ALabel";
        String propertyKey = "name";
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(404).delete(this.getSchemaIndexLabelPropertyUri(labelName, propertyKey));
    }

    @Test
    public void create_compound_index() {
        Map definition = MapUtil.map((Object[])new Object[]{"property_keys", Arrays.asList("first", "other")});
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().expectedStatus(400).payload(JsonHelper.createJsonFrom((Object)definition)).post(this.getSchemaIndexLabelUri("a_label"));
    }

    private IndexDefinition createIndex(String labelName, String propertyKey) {
        try (Transaction tx = this.graphdb().beginTx();){
            IndexDefinition indexDefinition = this.graphdb().schema().indexFor(DynamicLabel.label((String)labelName)).on(propertyKey).create();
            tx.success();
            IndexDefinition indexDefinition2 = indexDefinition;
            return indexDefinition2;
        }
    }
}

