/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.transactional;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.DatatypeConverter;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.server.rest.transactional.ExecutionResultSerializer;
import org.neo4j.server.rest.transactional.StatementDeserializer;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionHandle;
import org.neo4j.server.rest.transactional.TransactionHandleRegistry;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.transactional.TransitionalTxManagementKernelTransaction;
import org.neo4j.server.rest.transactional.error.InvalidConcurrentTransactionAccess;
import org.neo4j.server.rest.web.TransactionUriScheme;
import org.neo4j.test.DoubleLatch;

public class ConcurrentTransactionAccessTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldThrowSpecificExceptionOnConcurrentTransactionAccess() throws Exception {
        TransactionHandleRegistry registry = new TransactionHandleRegistry((Clock)Mockito.mock(Clock.class), 0L, StringLogger.DEV_NULL);
        TransitionalPeriodTransactionMessContainer kernel = (TransitionalPeriodTransactionMessContainer)Mockito.mock(TransitionalPeriodTransactionMessContainer.class);
        Mockito.when((Object)kernel.newTransaction()).thenReturn(Mockito.mock(TransitionalTxManagementKernelTransaction.class));
        TransactionFacade actions = new TransactionFacade(kernel, null, (TransactionRegistry)registry, null);
        final TransactionHandle transactionHandle = actions.newTransactionHandle((TransactionUriScheme)new DisgustingUriScheme());
        final DoubleLatch latch = new DoubleLatch();
        final StatementDeserializer statements = (StatementDeserializer)Mockito.mock(StatementDeserializer.class);
        Mockito.when((Object)statements.hasNext()).thenAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocation) throws Throwable {
                latch.startAndAwaitFinish();
                return false;
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                transactionHandle.execute(statements, (ExecutionResultSerializer)Mockito.mock(ExecutionResultSerializer.class), (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
            }
        }).start();
        latch.awaitStart();
        try {
            actions.findTransactionHandle(DisgustingUriScheme.parseTxId(transactionHandle.uri()));
            Assert.fail((String)"should have thrown exception");
        }
        catch (InvalidConcurrentTransactionAccess invalidConcurrentTransactionAccess) {
        }
        finally {
            latch.finish();
        }
    }

    private static class DisgustingUriScheme
    implements TransactionUriScheme {
        private DisgustingUriScheme() {
        }

        private static long parseTxId(URI txUri) {
            return DatatypeConverter.parseLong((String)txUri.toString());
        }

        public URI txUri(long id) {
            return URI.create(String.valueOf(id));
        }

        public URI txCommitUri(long id) {
            return this.txUri(id);
        }
    }
}

