/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.server.rrd.sampler.NodeIdsInUseSampleable;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class NodeIdsInUseSampleableTest {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();
    public NodeIdsInUseSampleable sampleable;

    @Test
    public void emptyDbHasZeroNodesInUse() {
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void addANodeAndSampleableGoesUp() {
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)1.0));
    }

    @Before
    public void setUp() throws Exception {
        DependencyResolver dependencyResolver = this.dbRule.getGraphDatabaseAPI().getDependencyResolver();
        NeoStoreProvider neoStore = (NeoStoreProvider)dependencyResolver.resolveDependency(NeoStoreProvider.class);
        AvailabilityGuard guard = (AvailabilityGuard)dependencyResolver.resolveDependency(AvailabilityGuard.class);
        this.sampleable = new NodeIdsInUseSampleable(neoStore, guard);
    }
}

