/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import java.io.IOException;
import javax.management.MalformedObjectNameException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.server.rrd.sampler.DatabasePrimitivesSampleableBase;
import org.neo4j.server.rrd.sampler.NodeIdsInUseSampleable;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.ImpermanentDatabaseRule;

public class DatabasePrimitivesSampleableBaseDocTest {
    @Rule
    public final DatabaseRule dbRule = new ImpermanentDatabaseRule();
    private DatabasePrimitivesSampleableBase sampleable;

    @Test
    public void sampleTest() throws MalformedObjectNameException, IOException {
        Assert.assertTrue((String)"There should be no nodes in use.", (this.sampleable.getValue() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void rrd_uses_temp_dir() throws Exception {
        Assert.assertTrue((String)"There should be no nodes in use.", (this.sampleable.getValue() == 0.0 ? 1 : 0) != 0);
    }

    @Before
    public void setup() {
        DependencyResolver dependencyResolver = this.dbRule.getGraphDatabaseAPI().getDependencyResolver();
        NeoStoreProvider neoStore = (NeoStoreProvider)dependencyResolver.resolveDependency(NeoStoreProvider.class);
        AvailabilityGuard guard = (AvailabilityGuard)dependencyResolver.resolveDependency(AvailabilityGuard.class);
        this.sampleable = new NodeIdsInUseSampleable(neoStore, guard);
    }
}

