/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.InterruptThreadTimer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.helpers.Transactor;
import org.neo4j.server.helpers.UnitOfWork;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;

public class StartupTimeoutDocIT {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();
    TargetDirectory target = TargetDirectory.forTest(StartupTimeoutDocIT.class);
    private static final String DIRSEP = File.separator;
    @Rule
    public TargetDirectory.TestDirectory test = this.target.testDirectory();
    public CommunityNeoServer server;
    @Rule
    public TestName testName = new TestName();

    @Test
    public void shouldTimeoutIfStartupTakesLongerThanTimeout() throws IOException {
        ConfigurationBuilder configurator = this.buildProperties().withStartupTimeout(1L).atPort(7480).build();
        this.server = this.createSlowServer(configurator, true);
        try {
            this.server.start();
            Assert.fail((String)"Should have been interrupted.");
        }
        catch (ServerStartupException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Startup took longer than"));
        }
    }

    @Test
    public void shouldNotFailIfStartupTakesLessTimeThanTimeout() throws IOException {
        ConfigurationBuilder configurator = this.buildProperties().withStartupTimeout(100L).atPort(7480).build();
        this.server = new CommunityNeoServer(configurator, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().logging(DevNullLoggingService.DEV_NULL)){

            protected Iterable<ServerModule> createServerModules() {
                return Arrays.asList(new Object[0]);
            }
        };
        try {
            this.server.start();
        }
        catch (ServerStartupException e) {
            Assert.fail((String)"Should not have been interupted.");
        }
        InterruptThreadTimer timer = (InterruptThreadTimer)this.server.getDependencyResolver().resolveDependency(InterruptThreadTimer.class);
        Assert.assertThat((Object)timer.getState(), (Matcher)Is.is((Object)InterruptThreadTimer.State.IDLE));
    }

    @Test
    public void shouldNotTimeOutIfTimeoutDisabled() throws IOException {
        ConfigurationBuilder configurator = this.buildProperties().withStartupTimeout(0L).atPort(7480).build();
        this.server = this.createSlowServer(configurator, false);
        this.server.start();
    }

    private CommunityNeoServer createSlowServer(ConfigurationBuilder configurator, final boolean preventMovingFurtherThanStartingModules) {
        final AtomicReference timerStartSignal = new AtomicReference();
        CommunityNeoServer server = new CommunityNeoServer(configurator, (InternalAbstractGraphDatabase.Dependencies)GraphDatabaseDependencies.newDependencies().logging(DevNullLoggingService.DEV_NULL)){

            protected InterruptThreadTimer createInterruptStartupTimer() {
                InterruptThreadTimer realTimer = super.createInterruptStartupTimer();
                return this.timerThatStartsWhenModulesStartsLoading(realTimer);
            }

            private InterruptThreadTimer timerThatStartsWhenModulesStartsLoading(final InterruptThreadTimer realTimer) {
                return new InterruptThreadTimer(){

                    public boolean wasTriggered() {
                        return realTimer.wasTriggered();
                    }

                    public void stopCountdown() {
                        realTimer.stopCountdown();
                    }

                    public void startCountdown() {
                        timerStartSignal.set(new Runnable(){

                            @Override
                            public void run() {
                                realTimer.startCountdown();
                            }
                        });
                    }

                    public long getTimeoutMillis() {
                        return realTimer.getTimeoutMillis();
                    }

                    public InterruptThreadTimer.State getState() {
                        return realTimer.getState();
                    }
                };
            }

            protected Iterable<ServerModule> createServerModules() {
                ServerModule slowModule = new ServerModule(){

                    public void start() {
                        ((Runnable)timerStartSignal.get()).run();
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                        if (preventMovingFurtherThanStartingModules) {
                            Assert.fail((String)"Should not get here");
                        }
                    }

                    public void stop() {
                    }
                };
                return Arrays.asList(slowModule);
            }
        };
        return server;
    }

    private ConfiguratorBuilder buildProperties() throws IOException {
        new File(this.test.directory().getAbsolutePath() + DIRSEP + "conf").mkdirs();
        Properties databaseProperties = new Properties();
        String databasePropertiesFileName = this.test.directory().getAbsolutePath() + DIRSEP + "conf" + DIRSEP + "neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        Properties serverProperties = new Properties();
        String serverPropertiesFilename = this.test.directory().getAbsolutePath() + DIRSEP + "conf" + DIRSEP + "neo4j-server.properties";
        serverProperties.setProperty(Configurator.DATABASE_LOCATION_PROPERTY_KEY, this.test.directory().getAbsolutePath() + DIRSEP + "data" + DIRSEP + "graph.db");
        serverProperties.setProperty(Configurator.DB_TUNING_PROPERTY_FILE_KEY, databasePropertiesFileName);
        serverProperties.setProperty("org.neo4j.server.properties", serverPropertiesFilename);
        serverProperties.store(new FileWriter(serverPropertiesFilename), null);
        return new ConfiguratorBuilder((ConfigurationBuilder)new PropertyFileConfigurator(new File(serverPropertiesFilename)));
    }

    @After
    public void stopServer() {
        if (this.server != null) {
            this.server.stop();
            this.server = null;
        }
    }

    private void clearAll() {
        new Transactor(this.dbRule.getGraphDatabaseService(), new UnitOfWork(){

            @Override
            public void doWork() {
                this.deleteAllNodesAndRelationships(StartupTimeoutDocIT.this.dbRule.getGraphDatabaseService());
                this.deleteAllIndexes(StartupTimeoutDocIT.this.dbRule.getGraphDatabaseService());
            }

            private void deleteAllNodesAndRelationships(GraphDatabaseService db) {
                ResourceIterable allNodes = GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes();
                for (Node n : allNodes) {
                    Iterable relationships = n.getRelationships();
                    for (Relationship rel : relationships) {
                        rel.delete();
                    }
                    if (n.getId() != 0L) {
                        n.delete();
                        continue;
                    }
                    for (String key : n.getPropertyKeys()) {
                        n.removeProperty(key);
                    }
                }
            }

            private void deleteAllIndexes(GraphDatabaseService db) {
                IndexManager indexManager = db.index();
                for (String indexName : indexManager.nodeIndexNames()) {
                    try {
                        db.index().forNodes(indexName).delete();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                for (String indexName : indexManager.relationshipIndexNames()) {
                    try {
                        db.index().forRelationships(indexName).delete();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
                for (String k : indexManager.getNodeAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getNodeAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getNodeAutoIndexer().setEnabled(false);
                for (String k : indexManager.getRelationshipAutoIndexer().getAutoIndexedProperties()) {
                    indexManager.getRelationshipAutoIndexer().stopAutoIndexingProperty(k);
                }
                indexManager.getRelationshipAutoIndexer().setEnabled(false);
            }
        }).execute();
    }

    @Deprecated
    private static class ConfiguratorBuilder {
        private final ConfigurationBuilder configurator;

        public ConfiguratorBuilder(ConfigurationBuilder initialConfigurator) {
            this.configurator = initialConfigurator;
        }

        public ConfiguratorBuilder atPort(int port) {
            this.setProperty(Configurator.WEBSERVER_PORT_PROPERTY_KEY, String.valueOf(port));
            return this;
        }

        public ConfiguratorBuilder withStartupTimeout(long seconds) {
            this.setProperty(Configurator.STARTUP_TIMEOUT, String.valueOf(seconds));
            return this;
        }

        public ConfigurationBuilder build() {
            return this.configurator;
        }

        private void setProperty(String key, String value) {
            Map params = this.configurator.configuration().getParams();
            params.put(key, value);
            this.configurator.configuration().applyChanges(params);
        }
    }
}

