/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd.sampler;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.server.rrd.sampler.DatabasePrimitivesSampleableBase;

public class DatabasePrimitivesSampleableBaseTest {
    @Test
    public void shouldSampleOnlyWhenDatabaseIsAvailable() throws Throwable {
        double expected = 42.0;
        TheDatabasePrimitivesSampleableBase sampleable = this.createSampleable(true, expected);
        double value = sampleable.getValue();
        Assert.assertEquals((double)expected, (double)value, (double)0.0);
    }

    @Test
    public void shouldNotSampleWhenDatabaseIsNotAvailable() throws Throwable {
        TheDatabasePrimitivesSampleableBase sampleable = this.createSampleable(false, 42.0);
        double value = sampleable.getValue();
        Assert.assertEquals((double)0.0, (double)value, (double)0.0);
    }

    private TheDatabasePrimitivesSampleableBase createSampleable(boolean isAvailable, double sampleValue) {
        AvailabilityGuard guard = (AvailabilityGuard)Mockito.mock(AvailabilityGuard.class);
        Mockito.when((Object)guard.isAvailable(0L)).thenReturn((Object)isAvailable);
        return new TheDatabasePrimitivesSampleableBase(sampleValue, guard);
    }

    private static class TheDatabasePrimitivesSampleableBase
    extends DatabasePrimitivesSampleableBase {
        private final double sampleValue;

        public TheDatabasePrimitivesSampleableBase(double sampleValue, AvailabilityGuard guard) {
            super((NeoStoreProvider)Mockito.mock(NeoStoreProvider.class), guard);
            this.sampleValue = sampleValue;
        }

        protected double readValue(NeoStore neoStore) {
            return this.sampleValue;
        }

        public String getName() {
            return "name";
        }
    }
}

