/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.server;

import java.util.concurrent.Callable;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.neo4j.server.NeoServer;
import org.neo4j.server.helpers.ServerHelper;
import org.neo4j.test.Mute;
import org.neo4j.test.server.ServerHolder;

public class SharedServerTestBase {
    private static boolean useExternal = Boolean.valueOf(System.getProperty("neo-server.external", "false"));
    private static NeoServer server;
    @Rule
    public Mute mute = Mute.muteAll();

    protected static NeoServer server() {
        return server;
    }

    protected final void cleanDatabase() {
        if (!useExternal) {
            ServerHelper.cleanTheDatabase(server);
        }
    }

    @BeforeClass
    public static void allocateServer() throws Throwable {
        if (!useExternal) {
            Mute.muteAll().call((Callable)new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    server = ServerHolder.allocate();
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void releaseServer() throws Exception {
        if (!useExternal) {
            try {
                Mute.muteAll().call((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        ServerHolder.release(server);
                        return null;
                    }
                });
            }
            finally {
                server = null;
            }
        }
    }
}

