/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.Bootstrapper;
import org.neo4j.test.Mute;
import org.neo4j.test.server.ExclusiveServerTestBase;

public abstract class BaseBootstrapperTest
extends ExclusiveServerTestBase {
    @Rule
    public final Mute mute = Mute.muteAll();
    private Bootstrapper bootstrapper;

    @Before
    @After
    public void cleanUpAfterBootstrapper() throws Exception {
        if (this.bootstrapper != null) {
            String baseDir = this.bootstrapper.getServer().getDatabase().getLocation();
            this.bootstrapper.stop();
            FileUtils.deleteRecursively((File)new File(baseDir));
        }
    }

    protected abstract Bootstrapper newBootstrapper();

    @Test
    public void shouldStartStopNeoServerWithoutAnyConfigFiles() {
        this.bootstrapper = this.newBootstrapper();
        Integer resultCode = this.bootstrapper.start();
        Assert.assertEquals((Object)Bootstrapper.OK, (Object)resultCode);
        Assert.assertNotNull((Object)this.bootstrapper.getServer());
        this.bootstrapper.stop();
    }
}

