/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class DatabaseTuningDocIT
extends ExclusiveServerTestBase {
    @Ignore(value="Relies on internal config, which is bad")
    @Test
    public void shouldLoadAKnownGoodPropertyFile() throws IOException {
        CommunityNeoServer server = CommunityServerBuilder.server().usingDatabaseDir(this.folder.cleanDirectory(this.name.getMethodName()).getAbsolutePath()).withDefaultDatabaseTuning().build();
        server.start();
        Map<Object, Object> params = null;
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.nodestore.db.mapped_memory", "25M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.relationshipstore.db.mapped_memory", "50M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.propertystore.db.mapped_memory", "90M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.propertystore.db.strings.mapped_memory", "130M", params));
        Assert.assertTrue((boolean)this.propertyAndValuePresentIn("neostore.propertystore.db.arrays.mapped_memory", "130M", params));
        server.stop();
    }

    private boolean propertyAndValuePresentIn(String name, String value, Map<Object, Object> params) {
        Object paramValue = params.get(name);
        return paramValue != null && paramValue.toString().equals(value);
    }

    @Test
    public void shouldLogWarningAndContinueIfTuningFilePropertyDoesNotResolve() throws IOException {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        CommunityNeoServer server = CommunityServerBuilder.server((LogProvider)logProvider).usingDatabaseDir(this.folder.cleanDirectory(this.name.getMethodName()).getAbsolutePath()).withNonResolvableTuningFile().build();
        server.start();
        logProvider.assertContainsMessageContaining("The specified file for database performance tuning properties [%s] does not exist.");
        server.stop();
    }
}

