/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Arrays;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityServerBuilder;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class Neo4jDataProtocolIT
extends ExclusiveServerTestBase {
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();
    private CommunityNeoServer server;

    @After
    public void stopTheServer() {
        this.server.stop();
    }

    @Test
    public void shouldLaunchNDP() throws Throwable {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.ndp_enabled.name(), "true").usingDatabaseDir(this.tmpDir.getRoot().getAbsolutePath()).build();
        this.server.start();
        this.assertEventuallyServerResponds("localhost", 7687);
    }

    @Test
    public void shouldBeAbleToSpecifyHostAndPort() throws Throwable {
        this.server = CommunityServerBuilder.server().withProperty(ServerSettings.ndp_enabled.name(), "true").withProperty(ServerSettings.ndp_socket_address.name(), "localhost:8776").usingDatabaseDir(this.tmpDir.getRoot().getAbsolutePath()).build();
        this.server.start();
        this.assertEventuallyServerResponds("localhost", 8776);
    }

    private void assertEventuallyServerResponds(String host, int port) throws IOException, InterruptedException {
        long timeout = System.currentTimeMillis() + 30000L;
        do {
            if (this.serverResponds(host, port)) {
                return;
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() <= timeout);
        throw new RuntimeException("Waited for 30 seconds for server to respond to HTTP calls, but no response, timing out to avoid blocking forever.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean serverResponds(String host, int port) throws IOException, InterruptedException {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress(host, port));
            OutputStream out = socket.getOutputStream();
            InputStream in = socket.getInputStream();
            out.write(new byte[]{0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
            byte[] accepted = new byte[4];
            in.read(accepted);
            boolean bl = Arrays.equals(accepted, new byte[]{0, 0, 0, 1});
            return bl;
        }
        catch (ConnectException e) {
            return false;
        }
    }
}

