/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellSettings;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.server.ExclusiveServerTestBase;

public class NeoServerShellConfigIT
extends ExclusiveServerTestBase {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void shouldBeAbleToOverrideShellConfig() throws Throwable {
        final int customPort = this.findFreeShellPortToUse(8881);
        CommunityNeoServer server = new CommunityNeoServer(new ConfigurationBuilder(){

            public Config configuration() {
                return new Config(MapUtil.stringMap((String[])new String[]{Configurator.DATABASE_LOCATION_PROPERTY_KEY, NeoServerShellConfigIT.this.testDir.absolutePath()}));
            }

            public Map<String, String> getDatabaseTuningProperties() {
                return MapUtil.stringMap((String[])new String[]{ShellSettings.remote_shell_enabled.name(), "true", ShellSettings.remote_shell_port.name(), "" + customPort});
            }
        }, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance()), (LogProvider)NullLogProvider.getInstance());
        server.start();
        ShellLobby.newClient((int)customPort).shutdown();
        server.stop();
    }

    @Test
    public void connectWithShellOnDefaultPortWhenNoShellConfigSupplied() throws Throwable {
        CommunityNeoServer server = new CommunityNeoServer(new ConfigurationBuilder(){

            public Config configuration() {
                return new Config(MapUtil.stringMap((String[])new String[]{Configurator.DATABASE_LOCATION_PROPERTY_KEY, NeoServerShellConfigIT.this.testDir.absolutePath()}));
            }

            public Map<String, String> getDatabaseTuningProperties() {
                return MapUtil.stringMap((String[])new String[0]);
            }
        }, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)NullLogProvider.getInstance()), (LogProvider)NullLogProvider.getInstance());
        server.start();
        ShellLobby.newClient().shutdown();
        server.stop();
    }

    private int findFreeShellPortToUse(int startingPort) {
        try {
            while (true) {
                ShellLobby.newClient((int)startingPort++).shutdown();
            }
        }
        catch (ShellException e) {
            return startingPort;
        }
    }
}

