/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Log;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.Mute;

public class PropertyFileConfiguratorTest {
    @Rule
    public final Mute mute = Mute.muteAll();
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();
    private final Log log = FormattedLog.toOutputStream((OutputStream)System.out);

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldLoadItEvenIfNotSpecified() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile, this.log);
        Assert.assertEquals((Object)"25M", configurator.getDatabaseTuningProperties().get(GraphDatabaseSettings.nodestore_mapped_memory_size.name()));
    }

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldNotLoadIfAnotherSpecified() throws IOException {
        int unlikelyDefaultMemoryMappedValue = 8351;
        File databaseTuningPropertyFileWeWantToUse = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).mappedMemory(unlikelyDefaultMemoryMappedValue).build();
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withDbTuningPropertyFile(databaseTuningPropertyFileWeWantToUse).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.newFolder()).build();
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(emptyPropertyFile, this.log);
        Assert.assertEquals((Object)(String.valueOf(unlikelyDefaultMemoryMappedValue) + "M"), configurator.getDatabaseTuningProperties().get(GraphDatabaseSettings.nodestore_mapped_memory_size.name()));
    }

    @Test
    public void shouldLogInfoWhenDefaultingToTuningPropertiesFileInTheSameDirectoryAsTheNeoServerPropertiesFile() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        File tuningPropertiesFile = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        new PropertyFileConfigurator(emptyPropertyFile, logProvider.getLog(this.getClass()));
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).warn("No database tuning file explicitly set, defaulting to [%s]", new Object[]{tuningPropertiesFile.getAbsolutePath()})});
    }

    @Test
    public void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() throws IOException {
        File propertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue(Configurator.THIRD_PARTY_PACKAGES_KEY, "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        PropertyFileConfigurator propertyFileConfigurator = new PropertyFileConfigurator(propertyFile, this.log);
        List thirdpartyJaxRsPackages = (List)propertyFileConfigurator.configuration().get(ServerSettings.third_party_packages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
        Assert.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).getMountPoint());
        Assert.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).getMountPoint());
        Assert.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).getMountPoint());
    }

    @Test
    public void shouldWorkFineWhenSpecifiedPropertiesFileDoesNotExist() {
        File nonExistentFilePropertiesFile = new File("/tmp/" + System.currentTimeMillis());
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(nonExistentFilePropertiesFile, this.log);
        Assert.assertTrue((boolean)configurator.getDatabaseTuningProperties().isEmpty());
    }
}

