/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.ServerTestUtils;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.PropertyFileConfigurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.LifecycleManagingDatabase;
import org.neo4j.server.preflight.PreFlightTasks;
import org.neo4j.server.preflight.PreflightTask;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.test.ImpermanentGraphDatabase;

public class CommunityServerBuilder {
    protected final LogProvider logProvider;
    private String portNo = "7474";
    private String maxThreads = null;
    protected String dbDir = null;
    private String webAdminUri = "/db/manage/";
    private String webAdminDataUri = "/db/data/";
    protected PreFlightTasks preflightTasks;
    private final HashMap<String, String> thirdPartyPackages = new HashMap();
    private final Properties arbitraryProperties = new Properties();
    public static LifecycleManagingDatabase.GraphFactory IN_MEMORY_DB = new LifecycleManagingDatabase.GraphFactory(){

        public GraphDatabaseAPI newGraphDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            File storeDir = (File)config.get(ServerInternalSettings.legacy_db_location);
            Map params = config.getParams();
            params.put(GraphDatabaseFacadeFactory.Configuration.ephemeral.name(), "true");
            return new ImpermanentGraphDatabase(storeDir, params, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)dependencies));
        }
    };
    private WhatToDo action;
    protected Clock clock = null;
    private String[] autoIndexedNodeKeys = null;
    private String[] autoIndexedRelationshipKeys = null;
    private String host = null;
    private String[] securityRuleClassNames;
    public boolean persistent;
    private Boolean httpsEnabled = Boolean.FALSE;

    public static CommunityServerBuilder server(LogProvider logProvider) {
        return new CommunityServerBuilder(logProvider);
    }

    public static CommunityServerBuilder server() {
        return new CommunityServerBuilder((LogProvider)NullLogProvider.getInstance());
    }

    public CommunityNeoServer build() throws IOException {
        if (this.dbDir == null && this.persistent) {
            throw new IllegalStateException("Must specify path");
        }
        File configFile = this.buildBefore();
        Log log = this.logProvider.getLog(this.getClass());
        PropertyFileConfigurator configurator = new PropertyFileConfigurator(configFile, log);
        Monitors monitors = new Monitors();
        return this.build(configFile, (ConfigurationBuilder)configurator, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies().userLogProvider(this.logProvider).monitors(monitors));
    }

    protected CommunityNeoServer build(File configFile, ConfigurationBuilder configurator, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        return new TestCommunityNeoServer(configurator, configFile, dependencies, this.logProvider);
    }

    public File createPropertiesFiles() throws IOException {
        File temporaryConfigFile = ServerTestUtils.createTempPropertyFile();
        this.createPropertiesFile(temporaryConfigFile);
        this.createTuningFile(temporaryConfigFile);
        return temporaryConfigFile;
    }

    public CommunityServerBuilder withClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    private void createPropertiesFile(File temporaryConfigFile) {
        String propertyKeys;
        Map properties = MapUtil.stringMap((String[])new String[]{Configurator.MANAGEMENT_PATH_PROPERTY_KEY, this.webAdminUri, Configurator.REST_API_PATH_PROPERTY_KEY, this.webAdminDataUri});
        if (this.dbDir != null) {
            properties.put(Configurator.DATABASE_LOCATION_PROPERTY_KEY, this.dbDir);
        }
        if (this.portNo != null) {
            properties.put(Configurator.WEBSERVER_PORT_PROPERTY_KEY, this.portNo);
        }
        if (this.host != null) {
            properties.put(Configurator.WEBSERVER_ADDRESS_PROPERTY_KEY, this.host);
        }
        if (this.maxThreads != null) {
            properties.put(Configurator.WEBSERVER_MAX_THREADS_PROPERTY_KEY, this.maxThreads);
        }
        if (this.thirdPartyPackages.keySet().size() > 0) {
            properties.put(Configurator.THIRD_PARTY_PACKAGES_KEY, ServerTestUtils.asOneLine(this.thirdPartyPackages));
        }
        if (this.autoIndexedNodeKeys != null && this.autoIndexedNodeKeys.length > 0) {
            properties.put("node_auto_indexing", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedNodeKeys, (String)",");
            properties.put("node_keys_indexable", propertyKeys);
        }
        if (this.autoIndexedRelationshipKeys != null && this.autoIndexedRelationshipKeys.length > 0) {
            properties.put("relationship_auto_indexing", "true");
            propertyKeys = StringUtils.join((Object[])this.autoIndexedRelationshipKeys, (String)",");
            properties.put("relationship_keys_indexable", propertyKeys);
        }
        if (this.securityRuleClassNames != null && this.securityRuleClassNames.length > 0) {
            propertyKeys = StringUtils.join((Object[])this.securityRuleClassNames, (String)",");
            properties.put(Configurator.SECURITY_RULES_KEY, propertyKeys);
        }
        if (this.httpsEnabled != null) {
            if (this.httpsEnabled.booleanValue()) {
                properties.put(Configurator.WEBSERVER_HTTPS_ENABLED_PROPERTY_KEY, "true");
            } else {
                properties.put(Configurator.WEBSERVER_HTTPS_ENABLED_PROPERTY_KEY, "false");
            }
        }
        properties.put(ServerSettings.auth_enabled.name(), "false");
        properties.put(ServerInternalSettings.auth_store.name(), "neo4j-home/data/dbms/authorization");
        for (Object key : this.arbitraryProperties.keySet()) {
            properties.put(String.valueOf(key), String.valueOf(this.arbitraryProperties.get(key)));
        }
        ServerTestUtils.writePropertiesToFile(properties, temporaryConfigFile);
    }

    private void createTuningFile(File temporaryConfigFile) throws IOException {
        if (this.action == WhatToDo.CREATE_GOOD_TUNING_FILE) {
            File databaseTuningPropertyFile = ServerTestUtils.createTempPropertyFile();
            Map properties = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m"});
            ServerTestUtils.writePropertiesToFile(properties, databaseTuningPropertyFile);
            ServerTestUtils.writePropertyToFile(Configurator.DB_TUNING_PROPERTY_FILE_KEY, databaseTuningPropertyFile.getAbsolutePath(), temporaryConfigFile);
        } else if (this.action == WhatToDo.CREATE_DANGLING_TUNING_FILE_PROPERTY) {
            ServerTestUtils.writePropertyToFile(Configurator.DB_TUNING_PROPERTY_FILE_KEY, ServerTestUtils.createTempPropertyFile().getAbsolutePath(), temporaryConfigFile);
        } else if (this.action == WhatToDo.CREATE_CORRUPT_TUNING_FILE) {
            File corruptTuningFile = this.trashFile();
            ServerTestUtils.writePropertyToFile(Configurator.DB_TUNING_PROPERTY_FILE_KEY, corruptTuningFile.getAbsolutePath(), temporaryConfigFile);
        }
    }

    private File trashFile() throws IOException {
        File f = ServerTestUtils.createTempPropertyFile();
        try (FileWriter fstream = new FileWriter(f, true);
             BufferedWriter out = new BufferedWriter(fstream);){
            for (int i = 0; i < 100; ++i) {
                out.write((int)System.currentTimeMillis());
            }
        }
        return f;
    }

    protected CommunityServerBuilder(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public CommunityServerBuilder persistent() {
        this.persistent = true;
        return this;
    }

    public CommunityServerBuilder onPort(int portNo) {
        this.portNo = String.valueOf(portNo);
        return this;
    }

    public CommunityServerBuilder withMaxJettyThreads(int maxThreads) {
        this.maxThreads = String.valueOf(maxThreads);
        return this;
    }

    public CommunityServerBuilder usingDatabaseDir(String dbDir) {
        this.dbDir = dbDir;
        return this;
    }

    public CommunityServerBuilder withRelativeWebAdminUriPath(String webAdminUri) {
        try {
            URI theUri = new URI(webAdminUri);
            this.webAdminUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withRelativeWebDataAdminUriPath(String webAdminDataUri) {
        try {
            URI theUri = new URI(webAdminDataUri);
            this.webAdminDataUri = theUri.isAbsolute() ? theUri.getPath() : theUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public CommunityServerBuilder withFailingPreflightTasks() {
        this.preflightTasks = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), new PreflightTask[0]){

            public boolean run() {
                return false;
            }

            public PreflightTask failedTask() {
                return new PreflightTask(){

                    public String getFailureMessage() {
                        return "mockFailure";
                    }

                    public boolean run() {
                        return false;
                    }
                };
            }
        };
        return this;
    }

    public CommunityServerBuilder withDefaultDatabaseTuning() {
        this.action = WhatToDo.CREATE_GOOD_TUNING_FILE;
        return this;
    }

    public CommunityServerBuilder withNonResolvableTuningFile() {
        this.action = WhatToDo.CREATE_DANGLING_TUNING_FILE_PROPERTY;
        return this;
    }

    public CommunityServerBuilder withCorruptTuningFile() {
        this.action = WhatToDo.CREATE_CORRUPT_TUNING_FILE;
        return this;
    }

    public CommunityServerBuilder withThirdPartyJaxRsPackage(String packageName, String mountPoint) {
        this.thirdPartyPackages.put(packageName, mountPoint);
        return this;
    }

    public CommunityServerBuilder withFakeClock() {
        this.clock = new FakeClock();
        return this;
    }

    public CommunityServerBuilder withAutoIndexingEnabledForNodes(String ... keys) {
        this.autoIndexedNodeKeys = keys;
        return this;
    }

    public CommunityServerBuilder withAutoIndexingEnabledForRelationships(String ... keys) {
        this.autoIndexedRelationshipKeys = keys;
        return this;
    }

    public CommunityServerBuilder onHost(String host) {
        this.host = host;
        return this;
    }

    public CommunityServerBuilder withSecurityRules(String ... securityRuleClassNames) {
        this.securityRuleClassNames = securityRuleClassNames;
        return this;
    }

    public CommunityServerBuilder withHttpsEnabled() {
        this.httpsEnabled = Boolean.TRUE;
        return this;
    }

    public CommunityServerBuilder withProperty(String key, String value) {
        this.arbitraryProperties.put(key, value);
        return this;
    }

    public CommunityServerBuilder withPreflightTasks(PreflightTask ... tasks) {
        this.preflightTasks = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), tasks);
        return this;
    }

    protected DatabaseActions createDatabaseActionsObject(Database database, ConfigurationBuilder configurator) {
        Clock clockToUse = this.clock != null ? this.clock : Clock.SYSTEM_CLOCK;
        return new DatabaseActions(new LeaseManager(clockToUse), ((Boolean)configurator.configuration().get(ServerInternalSettings.script_sandboxing_enabled)).booleanValue(), database.getGraph());
    }

    protected File buildBefore() throws IOException {
        File configFile = this.createPropertiesFiles();
        if (this.preflightTasks == null) {
            this.preflightTasks = new PreFlightTasks((LogProvider)NullLogProvider.getInstance(), new PreflightTask[0]){

                public boolean run() {
                    return true;
                }
            };
        }
        return configFile;
    }

    private class TestCommunityNeoServer
    extends CommunityNeoServer {
        private final File configFile;

        private TestCommunityNeoServer(ConfigurationBuilder propertyFileConfigurator, File configFile, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
            super(propertyFileConfigurator, LifecycleManagingDatabase.lifecycleManagingDatabase((LifecycleManagingDatabase.GraphFactory)(CommunityServerBuilder.this.persistent ? COMMUNITY_FACTORY : IN_MEMORY_DB)), dependencies, logProvider);
            this.configFile = configFile;
        }

        protected PreFlightTasks createPreflightTasks() {
            return CommunityServerBuilder.this.preflightTasks;
        }

        protected DatabaseActions createDatabaseActions() {
            return CommunityServerBuilder.this.createDatabaseActionsObject(this.database, this.configurator);
        }

        public void stop() {
            super.stop();
            this.configFile.delete();
        }
    }

    private static enum WhatToDo {
        CREATE_GOOD_TUNING_FILE,
        CREATE_DANGLING_TUNING_FILE_PROPERTY,
        CREATE_CORRUPT_TUNING_FILE;

    }
}

