/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.database.Database;
import org.neo4j.server.modules.ThirdPartyJAXRSModule;
import org.neo4j.server.web.WebServer;

public class ThirdPartyJAXRSModuleTest {
    @Test
    public void shouldReportThirdPartyPackagesAtSpecifiedMount() throws Exception {
        WebServer webServer = (WebServer)Mockito.mock(WebServer.class);
        CommunityNeoServer neoServer = (CommunityNeoServer)Mockito.mock(CommunityNeoServer.class);
        Mockito.when((Object)neoServer.baseUri()).thenReturn((Object)new URI("http://localhost:7575"));
        Mockito.when((Object)neoServer.getWebServer()).thenReturn((Object)webServer);
        Mockito.when((Object)neoServer.getDatabase()).thenReturn(Mockito.mock(Database.class));
        ConfigurationBuilder configurator = (ConfigurationBuilder)Mockito.mock(ConfigurationBuilder.class);
        Mockito.when((Object)neoServer.getConfigurationBuilder()).thenReturn((Object)configurator);
        Config config = (Config)Mockito.mock(Config.class);
        ArrayList<ThirdPartyJaxRsPackage> jaxRsPackages = new ArrayList<ThirdPartyJaxRsPackage>();
        String path = "/third/party/package";
        jaxRsPackages.add(new ThirdPartyJaxRsPackage("org.example.neo4j", path));
        Mockito.when((Object)config.get(ServerSettings.third_party_packages)).thenReturn(jaxRsPackages);
        Mockito.when((Object)neoServer.getConfigurationBuilder().configuration()).thenReturn((Object)config);
        ThirdPartyJAXRSModule module = new ThirdPartyJAXRSModule(webServer, config, (LogProvider)NullLogProvider.getInstance(), (NeoServer)neoServer);
        module.start();
        ((WebServer)Mockito.verify((Object)webServer)).addJAXRSPackages((List)Matchers.any(List.class), Matchers.anyString(), Matchers.anyCollection());
    }
}

