/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.recovery.StoreRecoverer;
import org.neo4j.kernel.impl.recovery.TestStoreRecoverer;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.preflight.PerformRecoveryIfNecessary;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestPerformRecoveryIfNecessary {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());
    public String homeDirectory;
    public String storeDirectory;

    @Before
    public void createDirs() {
        this.homeDirectory = this.testDir.directory().getAbsolutePath();
        this.storeDirectory = new File(this.homeDirectory, "data" + File.separator + "graph.db").getAbsolutePath();
    }

    @Test
    public void shouldNotDoAnythingIfNoDBPresent() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = this.buildProperties();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), (LogProvider)logProvider);
        Assert.assertThat((String)"Recovery task runs successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"No database should have been created.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)false));
        logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void doesNotPrintAnythingIfDatabaseWasCorrectlyShutdown() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Config config = this.buildProperties();
        new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDirectory).shutdown();
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), (LogProvider)logProvider);
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)true));
        logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void shouldPerformRecoveryIfNecessary() throws Exception {
        AssertableLogProvider logProvider = new AssertableLogProvider();
        StoreRecoverer recoverer = new StoreRecoverer();
        Config config = this.buildProperties();
        new TestGraphDatabaseFactory().newEmbeddedDatabase(this.storeDirectory).shutdown();
        TestStoreRecoverer.createLogFileForNextVersionWithSomeDataInIt((File)new File(this.storeDirectory), (FileSystemAbstraction)new DefaultFileSystemAbstraction());
        Assert.assertThat((String)"Store should need recovery", (Object)recoverer.recoveryNeededAt(new File(this.storeDirectory)), (Matcher)CoreMatchers.is((Object)true));
        PerformRecoveryIfNecessary task = new PerformRecoveryIfNecessary(config, new HashMap(), (LogProvider)logProvider);
        Assert.assertThat((String)"Recovery task should run successfully.", (Object)task.run(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)"Database should exist.", (Object)new File(this.storeDirectory).exists(), (Matcher)CoreMatchers.is((Object)true));
        logProvider.assertAtLeastOnce(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(PerformRecoveryIfNecessary.class).warn("Detected incorrectly shut down database, performing recovery..")});
        Assert.assertThat((String)"Store should be recovered", (Object)recoverer.recoveryNeededAt(new File(this.storeDirectory)), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shouldNotPerformRecoveryIfNoNeostorePresent() throws Exception {
        new File(this.storeDirectory).mkdirs();
        new File(this.storeDirectory, "unrelated_file").createNewFile();
        boolean actual = new StoreRecoverer().recoveryNeededAt(new File(this.storeDirectory), 0L);
        Assert.assertThat((String)"Recovery should not be needed", (Object)actual, (Matcher)CoreMatchers.is((Object)false));
    }

    private Config buildProperties() throws IOException {
        FileUtils.deleteRecursively((File)new File(this.homeDirectory));
        new File(this.homeDirectory + "/conf").mkdirs();
        Properties databaseProperties = new Properties();
        String databasePropertiesFileName = this.homeDirectory + "/conf/neo4j.properties";
        databaseProperties.store(new FileWriter(databasePropertiesFileName), null);
        Config serverProperties = new Config(MapUtil.stringMap((String[])new String[]{Configurator.DATABASE_LOCATION_PROPERTY_KEY, this.storeDirectory, Configurator.DB_TUNING_PROPERTY_FILE_KEY, databasePropertiesFileName}));
        return serverProperties;
    }
}

