/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.preflight;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.DuplicatingLogProvider;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.preflight.PerformUpgradeIfNecessary;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.Unzip;

public class TestPerformUpgradeIfNecessary {
    private final File HOME_DIRECTORY = TargetDirectory.forTest(TestPerformUpgradeIfNecessary.class).cleanDirectory("home");
    private final File STORE_DIRECTORY = new File(new File(this.HOME_DIRECTORY, "data"), "graph.db");
    private final File CONF_DIRECTORY = new File(this.HOME_DIRECTORY, "conf");
    private final File NEO4J_PROPERTIES = new File(this.CONF_DIRECTORY, "neo4j.properties");

    @Test
    public void shouldExitImmediatelyIfStoreIsAlreadyAtLatestVersion() throws IOException {
        Config serverConfig = this.buildProperties(false);
        GraphDatabaseBuilder builder = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.STORE_DIRECTORY.getPath());
        builder.newGraphDatabase().shutdown();
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverConfig, this.loadNeo4jProperties(), (LogProvider)NullLogProvider.getInstance(), monitor);
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }

    @Test
    public void shouldGiveHelpfulMessageIfAutoUpgradeParameterNotSet() throws IOException {
        Config serverProperties = this.buildProperties(false);
        this.prepareSampleLegacyDatabase(this.STORE_DIRECTORY);
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverProperties, this.loadNeo4jProperties(), (LogProvider)NullLogProvider.getInstance(), monitor);
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)false, (Object)exit);
        ((StoreUpgrader.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).migrationNeeded();
        ((StoreUpgrader.Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).migrationNotAllowed();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }

    @Test
    public void shouldExitCleanlyIfDatabaseMissingSoThatDatabaseCreationIsLeftToMainProcess() throws IOException {
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(this.buildProperties(true), this.loadNeo4jProperties(), (LogProvider)NullLogProvider.getInstance(), monitor);
        boolean exit = upgrader.run();
        Assert.assertEquals((Object)true, (Object)exit);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{monitor});
    }

    @Test
    public void shouldUpgradeDatabase() throws IOException {
        Config serverConfig = this.buildProperties(true);
        this.prepareSampleLegacyDatabase(this.STORE_DIRECTORY);
        StoreUpgrader.Monitor monitor = (StoreUpgrader.Monitor)Mockito.mock(StoreUpgrader.Monitor.class);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        AssertableLogProvider assertableLogProvider = new AssertableLogProvider();
        DuplicatingLogProvider logProvider = new DuplicatingLogProvider(new LogProvider[]{FormattedLogProvider.toOutputStream((OutputStream)outputStream), assertableLogProvider});
        PerformUpgradeIfNecessary upgrader = new PerformUpgradeIfNecessary(serverConfig, this.loadNeo4jProperties(), (LogProvider)logProvider, monitor);
        boolean success = upgrader.run();
        if (!success) {
            System.out.write(outputStream.toByteArray());
            Assert.fail();
        }
        InOrder order = Mockito.inOrder((Object[])new Object[]{monitor});
        ((StoreUpgrader.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).migrationNeeded();
        ((StoreUpgrader.Monitor)order.verify((Object)monitor, Mockito.times((int)1))).migrationCompleted();
        order.verifyNoMoreInteractions();
        assertableLogProvider.assertContainsMessageContaining("Migration completed");
    }

    private Config buildProperties(boolean allowStoreUpgrade) throws IOException {
        FileUtils.deleteRecursively((File)this.HOME_DIRECTORY);
        Assert.assertTrue((boolean)this.CONF_DIRECTORY.mkdirs());
        Properties databaseProperties = new Properties();
        if (allowStoreUpgrade) {
            databaseProperties.setProperty(GraphDatabaseSettings.allow_store_upgrade.name(), "true");
        }
        databaseProperties.store(new FileWriter(this.NEO4J_PROPERTIES.getAbsolutePath()), null);
        Config serverProperties = new Config(MapUtil.stringMap((String[])new String[]{Configurator.DATABASE_LOCATION_PROPERTY_KEY, this.STORE_DIRECTORY.getPath(), Configurator.DB_TUNING_PROPERTY_FILE_KEY, this.NEO4J_PROPERTIES.getAbsolutePath()}));
        return serverProperties;
    }

    private Map<String, String> loadNeo4jProperties() throws IOException {
        return MapUtil.load((File)new File(this.NEO4J_PROPERTIES.getAbsolutePath()));
    }

    private void prepareSampleLegacyDatabase(File workingDirectory) throws IOException {
        File resourceDirectory = Unzip.unzip(TestPerformUpgradeIfNecessary.class, (String)"exampledb.zip");
        FileUtils.deleteRecursively((File)workingDirectory);
        Assert.assertTrue((boolean)workingDirectory.mkdirs());
        FileUtils.copyRecursively((File)resourceDirectory, (File)workingDirectory);
    }
}

