/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.discovery;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.rest.discovery.DiscoveryService;
import org.neo4j.server.rest.repr.OutputFormat;
import org.neo4j.server.rest.repr.RepresentationFormat;
import org.neo4j.server.rest.repr.formats.JsonFormat;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.test.server.EntityOutputFormat;

public class DiscoveryServiceTest {
    @Test
    public void shouldReturnValidJSONWithDataAndManagementUris() throws Exception {
        Config mockConfig = (Config)Mockito.mock(Config.class);
        URI managementUri = new URI("/management");
        Mockito.when((Object)mockConfig.get(ServerInternalSettings.management_api_path)).thenReturn((Object)managementUri);
        URI dataUri = new URI("/data");
        Mockito.when((Object)mockConfig.get(ServerInternalSettings.rest_api_path)).thenReturn((Object)dataUri);
        Mockito.when((Object)mockConfig.get(ServerSettings.auth_enabled)).thenReturn((Object)false);
        String baseUri = "http://www.example.com";
        DiscoveryService ds = new DiscoveryService(mockConfig, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null));
        Response response = ds.getDiscoveryDocument();
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"management\" : \"" + baseUri + managementUri + "/\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"data\" : \"" + baseUri + dataUri + "/\"")));
    }

    @Ignore(value="Absolute URIs not supported in this config")
    @Test
    public void shouldReturnConfiguredUrlIfConfigIsAbsolute() throws Exception {
        Config mockConfig = (Config)Mockito.mock(Config.class);
        URI managementUri = new URI("http://absolutedomain/management");
        Mockito.when((Object)mockConfig.get(ServerInternalSettings.management_api_path)).thenReturn((Object)managementUri);
        URI dataUri = new URI("http://absolutedomain/management");
        Mockito.when((Object)mockConfig.get(ServerInternalSettings.rest_api_path)).thenReturn((Object)dataUri);
        String baseUri = "http://www.example.com";
        DiscoveryService ds = new DiscoveryService(mockConfig, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null));
        Response response = ds.getDiscoveryDocument();
        String json = new String((byte[])response.getEntity());
        Assert.assertNotNull((Object)json);
        Assert.assertThat((Object)json.length(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"\"\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"null")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"management\" : \"" + managementUri + "/\"")));
        Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"data\" : \"" + dataUri + "/\"")));
    }

    @Test
    public void shouldReturnRedirectToAbsoluteAPIUsingOutputFormat() throws Exception {
        Config mockConfig = (Config)Mockito.mock(Config.class);
        URI browserUri = new URI("/browser/");
        Mockito.when((Object)mockConfig.get(ServerInternalSettings.browser_path)).thenReturn((Object)browserUri);
        String baseUri = "http://www.example.com:5435";
        DiscoveryService ds = new DiscoveryService(mockConfig, (OutputFormat)new EntityOutputFormat((RepresentationFormat)new JsonFormat(), new URI(baseUri), null));
        Response response = ds.redirectToBrowser();
        Assert.assertThat((Object)response.getMetadata().getFirst((Object)"Location"), (Matcher)Matchers.is((Object)new URI("http://www.example.com:5435/browser/")));
    }
}

