/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.web;

import java.io.File;
import java.io.IOException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.server.WrappingNeoServerBootstrapper;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerConfigurator;
import org.neo4j.server.web.Jetty9WebServer;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.Mute;

public class TestJetty9WebServer {
    @Rule
    public Mute mute = Mute.muteAll();
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void shouldBeAbleToUsePortZero() throws IOException {
        Jetty9WebServer webServer = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), new Config());
        webServer.setPort(0);
        webServer.start();
        webServer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToRestart() throws Throwable {
        Jetty9WebServer server = new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), new Config());
        try {
            server.setAddress("127.0.0.1");
            server.setPort(7878);
            server.start();
            server.stop();
            server.start();
        }
        finally {
            try {
                server.stop();
            }
            catch (Throwable throwable) {}
        }
    }

    @Test
    public void shouldBeAbleToSetExecutionLimit() throws Throwable {
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase(new File("path"), MapUtil.stringMap((String[])new String[0]), (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies()){};
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)db);
        config.configuration().setProperty(Configurator.WEBSERVER_PORT_PROPERTY_KEY, (Object)"7476");
        config.configuration().setProperty(Configurator.WEBSERVER_LIMIT_EXECUTION_TIME_PROPERTY_KEY, (Object)"1000s");
        WrappingNeoServerBootstrapper testBootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)config);
        testBootstrapper.start();
        testBootstrapper.stop();
    }

    @Test
    public void shouldStopCleanlyEvenWhenItHasntBeenStarted() {
        new Jetty9WebServer((LogProvider)NullLogProvider.getInstance(), null).stop();
    }

    @Test
    public void shouldDisallowDirectoryListings() throws Exception {
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase(new File("path"), MapUtil.stringMap((String[])new String[0]), (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies()){};
        ServerConfigurator config = new ServerConfigurator((GraphDatabaseAPI)db);
        config.configuration().setProperty(Configurator.WEBSERVER_PORT_PROPERTY_KEY, (Object)"7477");
        WrappingNeoServerBootstrapper testBootstrapper = new WrappingNeoServerBootstrapper((GraphDatabaseAPI)db, (Configurator)config);
        testBootstrapper.start();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().build();){
            Assert.assertEquals((long)200L, (long)httpClient.execute((HttpUriRequest)new HttpGet("http://localhost:7477/browser/content/help/create.html")).getStatusLine().getStatusCode());
            Assert.assertEquals((long)403L, (long)httpClient.execute((HttpUriRequest)new HttpGet("http://localhost:7477/browser/content/help/")).getStatusLine().getStatusCode());
        }
        testBootstrapper.stop();
    }
}

