/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.neo4j.function.Predicate;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.NodePropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipPropertyExistenceConstraintDefinition;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.transaction.state.NeoStoreSupplier;
import org.neo4j.server.database.Database;

public class GraphDbHelper {
    private final Database database;

    public GraphDbHelper(Database database) {
        this.database = database;
    }

    public int getNumberOfNodes() {
        return (int)((NeoStore)((NeoStoreSupplier)this.database.getGraph().getDependencyResolver().resolveDependency(NeoStoreSupplier.class)).get()).getNodeStore().getNumberOfIdsInUse();
    }

    public int getNumberOfRelationships() {
        return (int)((NeoStore)((NeoStoreSupplier)this.database.getGraph().getDependencyResolver().resolveDependency(NeoStoreSupplier.class)).get()).getRelationshipStore().getNumberOfIdsInUse();
    }

    public Map<String, Object> getNodeProperties(long nodeId) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node node = this.database.getGraph().getNodeById(nodeId);
            Map allProperties = node.getAllProperties();
            tx.success();
            Map map = allProperties;
            return map;
        }
    }

    public void setNodeProperties(long nodeId, Map<String, Object> properties) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node node = this.database.getGraph().getNodeById(nodeId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                node.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
    }

    public long createNode(Label ... labels) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node node = this.database.getGraph().createNode(labels);
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    public long createNode(Map<String, Object> properties, Label ... labels) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node node = this.database.getGraph().createNode(labels);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                node.setProperty(entry.getKey(), entry.getValue());
            }
            tx.success();
            long l = node.getId();
            return l;
        }
    }

    public void deleteNode(long id) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node node = this.database.getGraph().getNodeById(id);
            node.delete();
            tx.success();
        }
    }

    public long createRelationship(String type, long startNodeId, long endNodeId) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node startNode = this.database.getGraph().getNodeById(startNodeId);
            Node endNode = this.database.getGraph().getNodeById(endNodeId);
            Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
    }

    public long createRelationship(String type) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node startNode = this.database.getGraph().createNode();
            Node endNode = this.database.getGraph().createNode();
            Relationship relationship = startNode.createRelationshipTo(endNode, (RelationshipType)DynamicRelationshipType.withName((String)type));
            tx.success();
            long l = relationship.getId();
            return l;
        }
    }

    public void setRelationshipProperties(long relationshipId, Map<String, Object> properties) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            for (Map.Entry<String, Object> propertyEntry : properties.entrySet()) {
                relationship.setProperty(propertyEntry.getKey(), propertyEntry.getValue());
            }
            tx.success();
        }
    }

    public Map<String, Object> getRelationshipProperties(long relationshipId) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            Map allProperties = relationship.getAllProperties();
            tx.success();
            Map map = allProperties;
            return map;
        }
    }

    public Relationship getRelationship(long relationshipId) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Relationship relationship = this.database.getGraph().getRelationshipById(relationshipId);
            tx.success();
            Relationship relationship2 = relationship;
            return relationship2;
        }
    }

    public void addNodeToIndex(String indexName, String key, Object value, long id) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            this.database.getGraph().index().forNodes(indexName).add((PropertyContainer)this.database.getGraph().getNodeById(id), key, value);
            tx.success();
        }
    }

    public Collection<Long> queryIndexedNodes(String indexName, String key, Object value) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : this.database.getGraph().index().forNodes(indexName).query(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
    }

    public Collection<Long> getIndexedNodes(String indexName, String key, Object value) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            ArrayList<Long> result = new ArrayList<Long>();
            for (Node node : this.database.getGraph().index().forNodes(indexName).get(key, value)) {
                result.add(node.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
    }

    public Collection<Long> getIndexedRelationships(String indexName, String key, Object value) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            ArrayList<Long> result = new ArrayList<Long>();
            for (Relationship relationship : this.database.getGraph().index().forRelationships(indexName).get(key, value)) {
                result.add(relationship.getId());
            }
            tx.success();
            ArrayList<Long> arrayList = result;
            return arrayList;
        }
    }

    public void addRelationshipToIndex(String indexName, String key, String value, long relationshipId) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            RelationshipIndex index = this.database.getGraph().index().forRelationships(indexName);
            index.add((PropertyContainer)this.database.getGraph().getRelationshipById(relationshipId), key, (Object)value);
            tx.success();
        }
    }

    public String[] getNodeIndexes() {
        try (Transaction transaction = this.database.getGraph().beginTx();){
            String[] stringArray = this.database.getGraph().index().nodeIndexNames();
            return stringArray;
        }
    }

    public Index<Node> createNodeFullTextIndex(String named) {
        try (Transaction transaction = this.database.getGraph().beginTx();){
            Index index = this.database.getGraph().index().forNodes(named, MapUtil.stringMap((String[])new String[]{"provider", "lucene", "type", "fulltext"}));
            transaction.success();
            Index index2 = index;
            return index2;
        }
    }

    public Index<Node> createNodeIndex(String named) {
        try (Transaction transaction = this.database.getGraph().beginTx();){
            Index nodeIndex = this.database.getGraph().index().forNodes(named);
            transaction.success();
            Index index = nodeIndex;
            return index;
        }
    }

    public String[] getRelationshipIndexes() {
        try (Transaction transaction = this.database.getGraph().beginTx();){
            String[] stringArray = this.database.getGraph().index().relationshipIndexNames();
            return stringArray;
        }
    }

    public long getFirstNode() {
        Throwable throwable = null;
        try (Transaction tx = this.database.getGraph().beginTx();){
            Node referenceNode = this.database.getGraph().getNodeById(0L);
            tx.success();
            long l = referenceNode.getId();
            return l;
        }
        catch (NotFoundException e) {
            Node newNode = this.database.getGraph().createNode();
            tx.success();
            long l = newNode.getId();
            return l;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    public Index<Relationship> createRelationshipIndex(String named) {
        try (Transaction transaction = this.database.getGraph().beginTx();){
            RelationshipIndex relationshipIndex = this.database.getGraph().index().forRelationships(named);
            transaction.success();
            RelationshipIndex relationshipIndex2 = relationshipIndex;
            return relationshipIndex2;
        }
    }

    public Iterable<String> getNodeLabels(long node) {
        return new IterableWrapper<String, Label>(this.database.getGraph().getNodeById(node).getLabels()){

            protected String underlyingObjectToObject(Label object) {
                return object.name();
            }
        };
    }

    public void addLabelToNode(long node, String labelName) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            this.database.getGraph().getNodeById(node).addLabel(DynamicLabel.label((String)labelName));
            tx.success();
        }
    }

    public Iterable<IndexDefinition> getSchemaIndexes(String labelName) {
        return this.database.getGraph().schema().getIndexes(DynamicLabel.label((String)labelName));
    }

    public IndexDefinition createSchemaIndex(String labelName, String propertyKey) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            IndexDefinition index = this.database.getGraph().schema().indexFor(DynamicLabel.label((String)labelName)).on(propertyKey).create();
            tx.success();
            IndexDefinition indexDefinition = index;
            return indexDefinition;
        }
    }

    public Iterable<ConstraintDefinition> getPropertyUniquenessConstraints(String labelName, final String propertyKey) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Iterable definitions = Iterables.filter((Predicate)new Predicate<ConstraintDefinition>(){

                public boolean test(ConstraintDefinition item) {
                    if (item.isConstraintType(ConstraintType.UNIQUENESS)) {
                        Iterable keys = item.getPropertyKeys();
                        return ((String)Iterables.single((Iterable)keys)).equals(propertyKey);
                    }
                    return false;
                }
            }, (Iterable)this.database.getGraph().schema().getConstraints(DynamicLabel.label((String)labelName)));
            tx.success();
            Iterable iterable = definitions;
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getNodePropertyExistenceConstraints(String labelName, String propertyKey) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            Iterable<ConstraintDefinition> definitions = GraphDbHelper.filterByConstraintTypeAndPropertyKey(this.database.getGraph().schema().getConstraints(DynamicLabel.label((String)labelName)), ConstraintType.NODE_PROPERTY_EXISTENCE, propertyKey);
            tx.success();
            Iterable<ConstraintDefinition> iterable = definitions;
            return iterable;
        }
    }

    public Iterable<ConstraintDefinition> getRelationshipPropertyExistenceConstraints(String typeName, String propertyKey) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            DynamicRelationshipType type = DynamicRelationshipType.withName((String)typeName);
            Iterable<ConstraintDefinition> definitions = GraphDbHelper.filterByConstraintTypeAndPropertyKey(this.database.getGraph().schema().getConstraints((RelationshipType)type), ConstraintType.RELATIONSHIP_PROPERTY_EXISTENCE, propertyKey);
            tx.success();
            Iterable<ConstraintDefinition> iterable = definitions;
            return iterable;
        }
    }

    public ConstraintDefinition createPropertyUniquenessConstraint(String labelName, List<String> propertyKeys) {
        try (Transaction tx = this.database.getGraph().beginTx();){
            ConstraintCreator creator = this.database.getGraph().schema().constraintFor(DynamicLabel.label((String)labelName));
            for (String propertyKey : propertyKeys) {
                creator = creator.assertPropertyIsUnique(propertyKey);
            }
            ConstraintDefinition result = creator.create();
            tx.success();
            ConstraintDefinition constraintDefinition = result;
            return constraintDefinition;
        }
    }

    public ConstraintDefinition createNodePropertyExistenceConstraint(String labelName, String propertyKey) {
        String query = String.format("CREATE CONSTRAINT ON (n:%s) ASSERT exists(n.%s)", labelName, propertyKey);
        this.database.getGraph().execute(query);
        this.awaitIndexes();
        return new NodePropertyExistenceConstraintDefinition((InternalSchemaActions)Mockito.mock(InternalSchemaActions.class), DynamicLabel.label((String)labelName), propertyKey);
    }

    public ConstraintDefinition createRelationshipPropertyExistenceConstraint(String typeName, String propertyKey) {
        String query = String.format("CREATE CONSTRAINT ON ()-[r:%s]-() ASSERT exists(r.%s)", typeName, propertyKey);
        this.database.getGraph().execute(query);
        this.awaitIndexes();
        return new RelationshipPropertyExistenceConstraintDefinition((InternalSchemaActions)Mockito.mock(InternalSchemaActions.class), (RelationshipType)DynamicRelationshipType.withName((String)typeName), propertyKey);
    }

    public long getLabelCount(long nodeId) {
        try (Transaction transaction = this.database.getGraph().beginTx();){
            long l = Iterables.count((Iterable)this.database.getGraph().getNodeById(nodeId).getLabels());
            return l;
        }
    }

    private static Iterable<ConstraintDefinition> filterByConstraintTypeAndPropertyKey(Iterable<ConstraintDefinition> definitions, final ConstraintType type, final String propertyKey) {
        return Iterables.filter((Predicate)new Predicate<ConstraintDefinition>(){

            public boolean test(ConstraintDefinition definition) {
                if (definition.isConstraintType(type)) {
                    Iterable keys = definition.getPropertyKeys();
                    return ((String)Iterables.single((Iterable)keys)).equals(propertyKey);
                }
                return false;
            }
        }, definitions);
    }

    private void awaitIndexes() {
        try (Transaction tx = this.database.getGraph().beginTx();){
            this.database.getGraph().schema().awaitIndexesOnline(10L, TimeUnit.SECONDS);
            tx.success();
        }
    }
}

