/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rrd;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.state.NeoStoreSupplier;
import org.neo4j.server.rrd.sampler.RelationshipCountSampleable;
import org.neo4j.test.TestGraphDatabaseFactory;

public class RelationshipCountSampleableTest {
    public GraphDatabaseAPI db;
    public RelationshipCountSampleable sampleable;

    @Test
    public void emptyDbHasZeroRelationships() {
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)0.0));
    }

    @Test
    public void addANodeAndSampleableGoesUp() {
        this.createARelationship(this.db);
        MatcherAssert.assertThat((Object)this.sampleable.getValue(), (Matcher)Is.is((Object)1.0));
    }

    private void createARelationship(GraphDatabaseAPI db) {
        try (Transaction tx = db.beginTx();){
            Node node1 = db.createNode();
            Node node2 = db.createNode();
            node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"friend"));
            tx.success();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabase();
        this.sampleable = new RelationshipCountSampleable((NeoStoreSupplier)this.db.getDependencyResolver().resolveDependency(NeoStoreSupplier.class));
    }

    @After
    public void shutdownDatabase() {
        this.db.shutdown();
    }
}

