/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.neo4j.function.Function;
import org.neo4j.function.Supplier;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.RunCarefully;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.LoggingProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.NeoServerProvider;
import org.neo4j.server.RoundRobinJobScheduler;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ConfigWrappingConfiguration;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.database.CypherExecutor;
import org.neo4j.server.database.CypherExecutorProvider;
import org.neo4j.server.database.Database;
import org.neo4j.server.database.DatabaseProvider;
import org.neo4j.server.database.ExecutionEngineProvider;
import org.neo4j.server.database.GraphDatabaseServiceProvider;
import org.neo4j.server.database.InjectableProvider;
import org.neo4j.server.database.RrdDbWrapper;
import org.neo4j.server.exception.ServerStartupErrors;
import org.neo4j.server.guard.GuardingRequestFilter;
import org.neo4j.server.modules.RESTApiModule;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.plugins.PluginInvocatorProvider;
import org.neo4j.server.plugins.PluginManager;
import org.neo4j.server.rest.paging.LeaseManager;
import org.neo4j.server.rest.repr.InputFormatProvider;
import org.neo4j.server.rest.repr.OutputFormatProvider;
import org.neo4j.server.rest.repr.RepresentationFormatRepository;
import org.neo4j.server.rest.transactional.TransactionFacade;
import org.neo4j.server.rest.transactional.TransactionFilter;
import org.neo4j.server.rest.transactional.TransactionHandleRegistry;
import org.neo4j.server.rest.transactional.TransactionRegistry;
import org.neo4j.server.rest.transactional.TransitionalPeriodTransactionMessContainer;
import org.neo4j.server.rest.web.DatabaseActions;
import org.neo4j.server.rrd.RrdDbProvider;
import org.neo4j.server.rrd.RrdFactory;
import org.neo4j.server.security.auth.AuthManager;
import org.neo4j.server.security.auth.FileUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.ssl.Certificates;
import org.neo4j.server.security.ssl.KeyStoreFactory;
import org.neo4j.server.security.ssl.KeyStoreInformation;
import org.neo4j.server.web.ServerInternalSettings;
import org.neo4j.server.web.SimpleUriBuilder;
import org.neo4j.server.web.WebServer;
import org.neo4j.server.web.WebServerProvider;

@Deprecated
public abstract class AbstractNeoServer
implements NeoServer {
    private static final long MINIMUM_TIMEOUT = 1000L;
    private static final long ROUNDING_SECOND = 1000L;
    private static final Pattern[] DEFAULT_URI_WHITELIST = new Pattern[]{Pattern.compile("/browser.*"), Pattern.compile("/webadmin.*"), Pattern.compile("/")};
    private final Database.Factory dbFactory;
    private final GraphDatabaseFacadeFactory.Dependencies dependencies;
    protected final LogProvider logProvider;
    protected final Log log;
    private final List<ServerModule> serverModules = new ArrayList<ServerModule>();
    private final SimpleUriBuilder uriBuilder = new SimpleUriBuilder();
    private final LifeSupport life = new LifeSupport();
    private Config config;
    protected Database database;
    protected CypherExecutor cypherExecutor;
    protected WebServer webServer;
    protected AuthManager authManager;
    protected KeyStoreInformation keyStoreInfo;
    private DatabaseActions databaseActions;
    private RoundRobinJobScheduler rrdDbScheduler;
    private RrdDbWrapper rrdDbWrapper;
    private TransactionFacade transactionFacade;
    private TransactionHandleRegistry transactionRegistry;
    private boolean initialized = false;
    private final Dependencies dependencyResolver = new Dependencies((Supplier)new Supplier<DependencyResolver>(){

        public DependencyResolver get() {
            Database db = (Database)AbstractNeoServer.this.dependencyResolver.resolveDependency(Database.class);
            return db.getGraph().getDependencyResolver();
        }
    });

    protected abstract Iterable<ServerModule> createServerModules();

    protected abstract WebServer createWebServer();

    public AbstractNeoServer(Config config, Database.Factory dbFactory, GraphDatabaseFacadeFactory.Dependencies dependencies, LogProvider logProvider) {
        this.config = config;
        this.dbFactory = dbFactory;
        this.dependencies = dependencies;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(this.getClass());
    }

    @Override
    public void init() {
        if (this.initialized) {
            return;
        }
        this.database = (Database)this.life.add(this.dependencyResolver.satisfyDependency((Object)this.dbFactory.newDatabase(this.config, this.dependencies)));
        FileUserRepository users = (FileUserRepository)this.life.add((Object)new FileUserRepository(((File)this.config.get(ServerInternalSettings.auth_store)).toPath(), this.logProvider));
        this.authManager = (AuthManager)((Object)this.life.add((Object)new AuthManager((UserRepository)users, Clock.SYSTEM_CLOCK, (boolean)((Boolean)this.config.get(ServerSettings.auth_enabled)))));
        this.webServer = this.createWebServer();
        if (this.getKeyStoreRequired()) {
            this.keyStoreInfo = this.createKeyStore();
        }
        for (ServerModule moduleClass : this.createServerModules()) {
            this.registerModule(moduleClass);
        }
        this.initialized = true;
    }

    @Override
    public void start() throws ServerStartupException {
        this.init();
        try {
            this.life.start();
            DiagnosticsManager diagnosticsManager = this.resolveDependency(DiagnosticsManager.class);
            Log diagnosticsLog = diagnosticsManager.getTargetLog();
            diagnosticsLog.info("--- SERVER STARTED START ---");
            this.databaseActions = this.createDatabaseActions();
            if (((Boolean)this.getConfig().get(ServerInternalSettings.webadmin_enabled)).booleanValue()) {
                this.rrdDbScheduler = new RoundRobinJobScheduler(this.logProvider);
                this.rrdDbWrapper = new RrdFactory(this.config, this.logProvider).createRrdDbAndSampler(this.database, this.rrdDbScheduler);
            }
            this.transactionFacade = this.createTransactionalActions();
            this.cypherExecutor = new CypherExecutor(this.database);
            this.configureWebServer();
            this.cypherExecutor.start();
            this.startModules();
            this.startWebServer();
            diagnosticsLog.info("--- SERVER STARTED END ---");
        }
        catch (Throwable t) {
            this.stopRrdDb();
            this.life.shutdown();
            throw ServerStartupErrors.translateToServerStartupError(t);
        }
    }

    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected DatabaseActions createDatabaseActions() {
        return new DatabaseActions(new LeaseManager(Clock.SYSTEM_CLOCK), (Boolean)this.config.get(ServerInternalSettings.script_sandboxing_enabled), this.database.getGraph());
    }

    private TransactionFacade createTransactionalActions() {
        final long timeoutMillis = this.getTransactionTimeoutMillis();
        final Clock clock = Clock.SYSTEM_CLOCK;
        this.transactionRegistry = new TransactionHandleRegistry(clock, timeoutMillis, this.logProvider);
        long runEvery = Math.round((double)timeoutMillis / 2.0);
        this.resolveDependency(JobScheduler.class).scheduleRecurring(JobScheduler.Groups.serverTransactionTimeout, new Runnable(){

            @Override
            public void run() {
                long maxAge = clock.currentTimeMillis() - timeoutMillis;
                AbstractNeoServer.this.transactionRegistry.rollbackSuspendedTransactionsIdleSince(maxAge);
            }
        }, runEvery, TimeUnit.MILLISECONDS);
        return new TransactionFacade(new TransitionalPeriodTransactionMessContainer(this.database.getGraph()), (QueryExecutionEngine)this.database.getGraph().getDependencyResolver().resolveDependency(QueryExecutionEngine.class), this.transactionRegistry, this.logProvider);
    }

    private long getTransactionTimeoutMillis() {
        long timeout = (Long)this.config.get(ServerSettings.transaction_timeout);
        return Math.max(timeout, 2000L);
    }

    protected final void registerModule(ServerModule module) {
        this.serverModules.add(module);
    }

    private void startModules() {
        for (ServerModule module : this.serverModules) {
            module.start();
        }
    }

    private void stopModules() {
        new RunCarefully(Iterables.map((Function)new Function<ServerModule, Runnable>(){

            public Runnable apply(final ServerModule module) {
                return new Runnable(){

                    @Override
                    public void run() {
                        module.stop();
                    }
                };
            }
        }, this.serverModules)).run();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    @Override
    public Configuration getConfiguration() {
        return new ConfigWrappingConfiguration(this.config);
    }

    private void configureWebServer() throws Exception {
        int webServerPort = this.getWebServerPort();
        String webServerAddr = this.getWebServerAddress();
        int maxThreads = (Integer)this.config.get(ServerSettings.webserver_max_threads);
        int sslPort = this.getHttpsPort();
        boolean sslEnabled = this.getHttpsEnabled();
        this.log.info("Starting HTTP on port %s (%d threads available)", new Object[]{webServerPort, maxThreads});
        this.webServer.setPort(webServerPort);
        this.webServer.setAddress(webServerAddr);
        this.webServer.setMaxThreads(maxThreads);
        this.webServer.setEnableHttps(sslEnabled);
        this.webServer.setHttpsPort(sslPort);
        this.webServer.setWadlEnabled((Boolean)this.config.get(ServerInternalSettings.wadl_enabled));
        this.webServer.setDefaultInjectables(this.createDefaultInjectables());
        if (sslEnabled) {
            this.log.info("Enabling HTTPS on port %s", new Object[]{sslPort});
            this.webServer.setHttpsCertificateInformation(this.keyStoreInfo);
        }
    }

    private void startWebServer() throws Exception {
        try {
            this.setUpHttpLogging();
            this.setUpTimeoutFilter();
            this.webServer.start();
            this.log.info("Remote interface ready and available at %s", new Object[]{this.baseUri()});
        }
        catch (Exception e) {
            this.log.error("Failed to start Neo Server on port %d: %s", new Object[]{this.getWebServerPort(), e.getMessage()});
            throw e;
        }
    }

    private void setUpHttpLogging() {
        if (!this.httpLoggingProperlyConfigured()) {
            return;
        }
        this.webServer.setHttpLoggingConfiguration((File)this.config.get(ServerSettings.http_log_config_file), (Boolean)this.config.get(ServerSettings.http_logging_enabled));
    }

    private void setUpTimeoutFilter() {
        if (this.getConfig().get(ServerSettings.webserver_limit_execution_time) == null) {
            return;
        }
        Guard guard = this.resolveDependency(Guard.class);
        if (guard == null) {
            throw new RuntimeException(String.format("Inconsistent configuration. In order to use %s, you must set %s.", ServerSettings.webserver_limit_execution_time.name(), GraphDatabaseSettings.execution_guard_enabled.name()));
        }
        GuardingRequestFilter filter = new GuardingRequestFilter(guard, (Long)this.getConfig().get(ServerSettings.webserver_limit_execution_time));
        this.webServer.addFilter(filter, "/*");
    }

    private boolean httpLoggingProperlyConfigured() {
        return this.loggingEnabled() && this.configLocated();
    }

    private boolean configLocated() {
        File logFile = (File)this.getConfig().get(ServerSettings.http_log_config_file);
        return logFile != null && logFile.exists();
    }

    private boolean loggingEnabled() {
        return (Boolean)this.getConfig().get(ServerSettings.http_logging_enabled);
    }

    protected int getWebServerPort() {
        return (Integer)this.config.get(ServerSettings.webserver_port);
    }

    protected boolean getHttpsEnabled() {
        return (Boolean)this.config.get(ServerSettings.webserver_https_enabled);
    }

    protected boolean getKeyStoreRequired() {
        return (Boolean)this.config.get(ServerSettings.webserver_https_enabled) != false || (Boolean)this.config.get(ServerSettings.bolt_tls_enabled) != false;
    }

    protected int getHttpsPort() {
        return (Integer)this.config.get(ServerSettings.webserver_https_port);
    }

    protected String getWebServerAddress() {
        return (String)this.config.get(ServerSettings.webserver_address);
    }

    protected Pattern[] getUriWhitelist() {
        return DEFAULT_URI_WHITELIST;
    }

    protected KeyStoreInformation createKeyStore() {
        File privateKeyPath = ((File)this.config.get(ServerSettings.tls_key_file)).getAbsoluteFile();
        File certificatePath = ((File)this.config.get(ServerSettings.tls_certificate_file)).getAbsoluteFile();
        try {
            if (!certificatePath.exists() && !privateKeyPath.exists()) {
                this.log.info("No SSL certificate found, generating a self-signed certificate..");
                Certificates certFactory = new Certificates();
                certFactory.createSelfSignedCertificate(certificatePath, privateKeyPath, this.getWebServerAddress());
            }
            if (!certificatePath.exists()) {
                throw new ServerStartupException(String.format("TLS private key found, but missing certificate at '%s'. Cannot start server without certificate.", certificatePath));
            }
            if (!privateKeyPath.exists()) {
                throw new ServerStartupException(String.format("TLS certificate found, but missing key at '%s'. Cannot start server without key.", privateKeyPath));
            }
            return new KeyStoreFactory().createKeyStore(privateKeyPath, certificatePath);
        }
        catch (GeneralSecurityException e) {
            throw new ServerStartupException("TLS certificate error occurred, unable to start server: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ServerStartupException("IO problem while loading or creating TLS certificates: " + e.getMessage(), e);
        }
    }

    @Override
    public void stop() {
        new RunCarefully(new Runnable[]{new Runnable(){

            @Override
            public void run() {
                AbstractNeoServer.this.stopWebServer();
            }
        }, new Runnable(){

            @Override
            public void run() {
                AbstractNeoServer.this.stopModules();
            }
        }, new Runnable(){

            @Override
            public void run() {
                AbstractNeoServer.this.stopRrdDb();
            }
        }, new Runnable(){

            @Override
            public void run() {
                AbstractNeoServer.this.life.stop();
            }
        }}).run();
        this.log.info("Successfully shutdown database");
    }

    private void stopRrdDb() {
        try {
            if (this.rrdDbScheduler != null) {
                this.rrdDbScheduler.stopJobs();
            }
            if (this.rrdDbWrapper != null) {
                this.rrdDbWrapper.close();
            }
            this.log.info("Successfully shutdown Neo4j Server");
        }
        catch (IOException e) {
            this.log.error("Unable to cleanly shut down statistics database", (Throwable)e);
        }
    }

    private void stopWebServer() {
        if (this.webServer != null) {
            this.webServer.stop();
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public TransactionRegistry getTransactionRegistry() {
        return this.transactionRegistry;
    }

    @Override
    public URI baseUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getWebServerPort(), false);
    }

    public URI httpsUri() {
        return this.uriBuilder.buildURI(this.getWebServerAddress(), this.getHttpsPort(), true);
    }

    public WebServer getWebServer() {
        return this.webServer;
    }

    @Override
    public Configurator getConfigurator() {
        return new ConfigurationBuilder.ConfigWrappingConfigurator(this.config);
    }

    @Override
    public PluginManager getExtensionManager() {
        if (this.hasModule(RESTApiModule.class)) {
            return this.getModule(RESTApiModule.class).getPlugins();
        }
        return null;
    }

    protected Collection<InjectableProvider<?>> createDefaultInjectables() {
        ArrayList singletons = new ArrayList();
        Database database = this.getDatabase();
        singletons.add(new DatabaseProvider(database));
        singletons.add(new DatabaseActions.Provider(this.databaseActions));
        singletons.add(new GraphDatabaseServiceProvider(database));
        singletons.add(new NeoServerProvider(this));
        singletons.add(InjectableProvider.providerForSingleton(new ConfigWrappingConfiguration(this.getConfig()), Configuration.class));
        singletons.add(InjectableProvider.providerForSingleton(this.getConfig(), Config.class));
        if (((Boolean)this.getConfig().get(ServerInternalSettings.webadmin_enabled)).booleanValue()) {
            singletons.add(new RrdDbProvider(this.rrdDbWrapper));
        }
        singletons.add(new WebServerProvider(this.getWebServer()));
        PluginInvocatorProvider pluginInvocatorProvider = new PluginInvocatorProvider(this);
        singletons.add(pluginInvocatorProvider);
        RepresentationFormatRepository repository = new RepresentationFormatRepository(this);
        singletons.add(new InputFormatProvider(repository));
        singletons.add(new OutputFormatProvider(repository));
        singletons.add(new CypherExecutorProvider(this.cypherExecutor));
        singletons.add(new ExecutionEngineProvider(this.cypherExecutor));
        singletons.add(InjectableProvider.providerForSingleton(this.transactionFacade, TransactionFacade.class));
        singletons.add(InjectableProvider.providerForSingleton(this.authManager, AuthManager.class));
        singletons.add(new TransactionFilter(database));
        singletons.add(new LoggingProvider(this.logProvider));
        singletons.add(InjectableProvider.providerForSingleton(this.logProvider.getLog(NeoServer.class), Log.class));
        return singletons;
    }

    private boolean hasModule(Class<? extends ServerModule> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private <T extends ServerModule> T getModule(Class<T> clazz) {
        for (ServerModule sm : this.serverModules) {
            if (sm.getClass() != clazz) continue;
            return (T)sm;
        }
        return null;
    }

    protected <T> T resolveDependency(Class<T> type) {
        return (T)this.dependencyResolver.resolveDependency(type);
    }
}

