/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.NeoServer;
import org.neo4j.server.ServerStartupException;
import org.neo4j.server.configuration.ServerConfigFactory;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.logging.JULBridge;
import org.neo4j.server.logging.JettyLogBridge;

@Deprecated
public abstract class Bootstrapper {
    public static final int OK = 0;
    public static final int WEB_SERVER_STARTUP_ERROR_CODE = 1;
    public static final int GRAPH_DATABASE_STARTUP_ERROR_CODE = 2;
    protected final LifeSupport life = new LifeSupport();
    protected NeoServer server;
    protected Config config;
    private Thread shutdownHook;
    protected GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies();
    private Log log;
    private String serverPort;

    public static void main(String[] args) {
        throw new UnsupportedOperationException("Invoking Bootstrapper#main() is no longer supported. If you see this error, please contact Neo4j support.");
    }

    public int start(File configFile, Pair<String, String> ... configOverrides) {
        FormattedLogProvider userLogProvider = FormattedLogProvider.withoutRenderingContext().toOutputStream((OutputStream)System.out);
        JULBridge.resetJUL();
        Logger.getLogger("").setLevel(Level.WARNING);
        JULBridge.forwardTo((LogProvider)userLogProvider);
        JettyLogBridge.setLogProvider((LogProvider)userLogProvider);
        this.log = userLogProvider.getLog(this.getClass());
        this.serverPort = "unknown port";
        try {
            this.config = this.createConfig(this.log, configFile, configOverrides);
            this.serverPort = String.valueOf(this.config.get(ServerSettings.webserver_port));
            this.dependencies = this.dependencies.userLogProvider((LogProvider)userLogProvider);
            this.life.start();
            this.checkCompatibility();
            this.server = this.createNeoServer(this.config, this.dependencies, (LogProvider)userLogProvider);
            this.server.start();
            this.addShutdownHook();
            return 0;
        }
        catch (ServerStartupException e) {
            e.describeTo(this.log);
            return 1;
        }
        catch (TransactionFailureException tfe) {
            String locationMsg = this.server == null ? "" : " Another process may be using database location " + this.server.getDatabase().getLocation();
            this.log.error(String.format("Failed to start Neo Server on port [%s].", this.serverPort) + locationMsg, (Throwable)tfe);
            return 2;
        }
        catch (Exception e) {
            this.log.error(String.format("Failed to start Neo Server on port [%s]", this.serverPort), (Throwable)e);
            return 1;
        }
    }

    private void checkCompatibility() {
        new JvmChecker(this.log, new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
    }

    protected abstract NeoServer createNeoServer(Config var1, GraphDatabaseDependencies var2, LogProvider var3);

    public int stop() {
        String location = "unknown location";
        try {
            if (this.server != null) {
                this.server.stop();
            }
            this.log.info("Successfully shutdown Neo Server on port [%s], database [%s]", new Object[]{this.serverPort, location});
            this.removeShutdownHook();
            this.life.shutdown();
            return 0;
        }
        catch (Exception e) {
            this.log.error("Failed to cleanly shutdown Neo Server on port [%s], database [%s]. Reason [%s] ", new Object[]{this.serverPort, location, e.getMessage(), e});
            return 1;
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null && !Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
            this.log.warn("Unable to remove shutdown hook");
        }
    }

    public NeoServer getServer() {
        return this.server;
    }

    protected void addShutdownHook() {
        this.shutdownHook = new Thread(){

            @Override
            public void run() {
                Bootstrapper.this.log.info("Neo4j Server shutdown initiated by request");
                if (Bootstrapper.this.server != null) {
                    Bootstrapper.this.server.stop();
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    protected Config createConfig(Log log, File file, Pair<String, String>[] configOverrides) throws IOException {
        return ServerConfigFactory.loadConfig(file, new File(System.getProperty("org.neo4j.server.properties", "config/neo4j-server.properties")), log, configOverrides);
    }
}

