/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.database;

import java.io.File;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.logging.Log;
import org.neo4j.server.database.Database;
import org.neo4j.server.web.ServerInternalSettings;

public class LifecycleManagingDatabase
implements Database {
    private final Config config;
    private final GraphFactory dbFactory;
    private final GraphDatabaseFacadeFactory.Dependencies dependencies;
    private final Log log;
    private boolean isRunning = false;
    private GraphDatabaseAPI graph;

    public static Database.Factory lifecycleManagingDatabase(final GraphFactory graphDbFactory) {
        return new Database.Factory(){

            @Override
            public Database newDatabase(Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                return new LifecycleManagingDatabase(config, graphDbFactory, dependencies);
            }
        };
    }

    public LifecycleManagingDatabase(Config config, GraphFactory dbFactory, GraphDatabaseFacadeFactory.Dependencies dependencies) {
        this.config = config;
        this.dbFactory = dbFactory;
        this.dependencies = dependencies;
        this.log = dependencies.userLogProvider().getLog(this.getClass());
    }

    @Override
    public String getLocation() {
        File file = (File)this.config.get(ServerInternalSettings.legacy_db_location);
        return file.getAbsolutePath();
    }

    @Override
    public GraphDatabaseAPI getGraph() {
        return this.graph;
    }

    public void init() throws Throwable {
    }

    public void start() throws Throwable {
        this.graph = this.dbFactory.newGraphDatabase(this.config, this.dependencies);
        if (!LifecycleManagingDatabase.testing()) {
            this.preLoadCypherCompiler();
        }
        this.isRunning = true;
        this.log.info("Successfully started database");
    }

    public void stop() throws Throwable {
        if (this.graph != null) {
            this.graph.shutdown();
            this.isRunning = false;
            this.graph = null;
            this.log.info("Successfully stopped database");
        }
    }

    public void shutdown() throws Throwable {
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preLoadCypherCompiler() {
        try {
            Result ignored = this.graph.execute("MATCH (a:` Arbitrary label name that really doesn't matter `) RETURN a LIMIT 0");
            Throwable throwable = null;
            if (ignored != null) {
                if (throwable != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                } else {
                    ignored.close();
                }
            }
        }
        catch (QueryExecutionException queryExecutionException) {
            // empty catch block
        }
    }

    private static boolean testing() {
        boolean testing = false;
        if (!$assertionsDisabled) {
            testing = true;
            if (!true) {
                throw new AssertionError((Object)"yes, this should be an assignment!");
            }
        }
        return testing;
    }

    public static interface GraphFactory {
        public GraphDatabaseAPI newGraphDatabase(Config var1, GraphDatabaseFacadeFactory.Dependencies var2);
    }
}

