/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.modules;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import org.neo4j.bolt.runtime.Sessions;
import org.neo4j.bolt.runtime.internal.StandardSessions;
import org.neo4j.bolt.runtime.internal.concurrent.ThreadedSessions;
import org.neo4j.bolt.transport.socket.NettyServer;
import org.neo4j.bolt.transport.socket.SocketProtocol;
import org.neo4j.bolt.transport.socket.SocketProtocolV1;
import org.neo4j.bolt.transport.socket.SocketTransport;
import org.neo4j.bolt.transport.socket.WebSocketTransport;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongObjectMap;
import org.neo4j.function.Function;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.Log;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.logging.Netty4LoggerFactory;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.security.ssl.KeyStoreInformation;
import org.neo4j.udc.UsageData;

public class BoltModule
implements ServerModule {
    private final Config config;
    private final DependencyResolver dependencyResolver;
    private final KeyStoreInformation ksi;
    private final LifeSupport life = new LifeSupport();

    public BoltModule(Config config, DependencyResolver dependencyResolver, KeyStoreInformation ksi) {
        this.config = config;
        this.dependencyResolver = dependencyResolver;
        this.ksi = ksi;
    }

    @Override
    public void start() {
        try {
            GraphDatabaseAPI api = (GraphDatabaseAPI)this.dependencyResolver.resolveDependency(GraphDatabaseAPI.class);
            final LogService logging = (LogService)this.dependencyResolver.resolveDependency(LogService.class);
            final UsageData usageData = (UsageData)this.dependencyResolver.resolveDependency(UsageData.class);
            JobScheduler scheduler = (JobScheduler)this.dependencyResolver.resolveDependency(JobScheduler.class);
            Log internalLog = logging.getInternalLog(Sessions.class);
            Log userLog = logging.getUserLog(Sessions.class);
            File certificateFile = (File)this.config.get(ServerSettings.tls_certificate_file);
            File keyFile = (File)this.config.get(ServerSettings.tls_key_file);
            HostnamePort socketAddress = (HostnamePort)this.config.get(ServerSettings.bolt_socket_address);
            HostnamePort webSocketAddress = (HostnamePort)this.config.get(ServerSettings.bolt_ws_address);
            if (((Boolean)this.config.get(ServerSettings.bolt_enabled)).booleanValue()) {
                final Sessions sessions = (Sessions)this.life.add((Object)new ThreadedSessions((Sessions)this.life.add((Object)new StandardSessions(api, usageData, logging)), scheduler, logging));
                PrimitiveLongObjectMap availableVersions = Primitive.longObjectMap();
                availableVersions.put(1L, (Object)new Function<Channel, SocketProtocol>(){

                    public SocketProtocol apply(Channel channel) {
                        return new SocketProtocolV1(logging, sessions.newSession(), channel, usageData);
                    }
                });
                SslContext sslCtx = this.createSSLContext(certificateFile, keyFile);
                InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Netty4LoggerFactory(logging.getInternalLogProvider()));
                this.life.add((Object)new NettyServer(scheduler.threadFactory(JobScheduler.Groups.boltNetworkIO), Arrays.asList(new SocketTransport(socketAddress, sslCtx, logging.getInternalLogProvider(), availableVersions), new WebSocketTransport(webSocketAddress, sslCtx, logging.getInternalLogProvider(), availableVersions))));
                internalLog.info("NDP Server extension loaded.");
                userLog.info("Experimental NDP support enabled! Listening for socket connections on " + socketAddress + " and for websocket connections on " + webSocketAddress + ".");
            }
            this.life.start();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | SSLException e) {
            throw new RuntimeException("Failed to configure TLS during NDP startup: " + e.getMessage(), e);
        }
    }

    private SslContext createSSLContext(File certificateFile, File keyFile) throws NoSuchAlgorithmException, KeyStoreException, UnrecoverableKeyException, SSLException {
        SslContext sslCtx = null;
        if (((Boolean)this.config.get(ServerSettings.bolt_tls_enabled)).booleanValue()) {
            KeyManagerFactory keyManager = KeyManagerFactory.getInstance("SunX509");
            keyManager.init(this.ksi.getKeyStore(), this.ksi.getKeyPassword());
            sslCtx = SslContextBuilder.forServer((File)certificateFile, (File)keyFile).sslProvider(SslProvider.JDK).keyManager(keyManager).build();
        }
        return sslCtx;
    }

    @Override
    public void stop() {
        this.life.stop();
    }
}

