/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.configuration;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.DatabaseTuningPropertyFileBuilder;
import org.neo4j.server.configuration.PropertyFileBuilder;
import org.neo4j.server.configuration.ServerConfigFactory;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.SuppressOutput;

public class ServerConfigFactoryTest {
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();
    private final Log log = NullLog.getInstance();

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldLoadItEvenIfNotSpecified() throws IOException {
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).withKernelId("fromdefaultlocation").build();
        Config config = ServerConfigFactory.loadConfig(null, (File)emptyPropertyFile, (Log)this.log, (Pair[])new Pair[0]);
        Assert.assertEquals((Object)"fromdefaultlocation", (Object)config.get(GraphDatabaseSettings.forced_kernel_id));
    }

    @Test
    public void whenDatabaseTuningFilePresentInDefaultLocationShouldNotLoadIfAnotherSpecified() throws IOException {
        File databaseTuningPropertyFileWeWantToUse = DatabaseTuningPropertyFileBuilder.builder(this.folder.getRoot()).withKernelId("shouldgetloaded").build();
        File emptyPropertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withDbTuningPropertyFile(databaseTuningPropertyFileWeWantToUse).build();
        DatabaseTuningPropertyFileBuilder.builder(this.folder.newFolder()).withKernelId("shouldnotgetloaded").build();
        Config config = ServerConfigFactory.loadConfig(null, (File)emptyPropertyFile, (Log)this.log, (Pair[])new Pair[0]);
        Assert.assertEquals((Object)"shouldgetloaded", (Object)config.get(GraphDatabaseSettings.forced_kernel_id));
    }

    @Test
    public void shouldRetainRegistrationOrderOfThirdPartyJaxRsPackages() throws IOException {
        File propertyFile = PropertyFileBuilder.builder(this.folder.getRoot()).withNameValue(Configurator.THIRD_PARTY_PACKAGES_KEY, "org.neo4j.extension.extension1=/extension1,org.neo4j.extension.extension2=/extension2,org.neo4j.extension.extension3=/extension3").build();
        Config config = ServerConfigFactory.loadConfig(null, (File)propertyFile, (Log)this.log, (Pair[])new Pair[0]);
        List thirdpartyJaxRsPackages = (List)config.get(ServerSettings.third_party_packages);
        Assert.assertEquals((long)3L, (long)thirdpartyJaxRsPackages.size());
        Assert.assertEquals((Object)"/extension1", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(0)).getMountPoint());
        Assert.assertEquals((Object)"/extension2", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(1)).getMountPoint());
        Assert.assertEquals((Object)"/extension3", (Object)((ThirdPartyJaxRsPackage)thirdpartyJaxRsPackages.get(2)).getMountPoint());
    }

    @Test
    public void shouldWorkFineWhenSpecifiedPropertiesFileDoesNotExist() {
        File nonExistentFilePropertiesFile = new File("/tmp/" + System.currentTimeMillis());
        Config config = ServerConfigFactory.loadConfig(null, (File)nonExistentFilePropertiesFile, (Log)this.log, (Pair[])new Pair[0]);
        Assert.assertNotNull((Object)config);
    }
}

