/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import com.sun.jersey.api.client.ClientResponse;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.repr.RelationshipRepresentationTest;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.TestData;

public class CreateRelationshipDocTest
extends AbstractRestFunctionalDocTestBase {
    @Test
    @GraphDescription.Graph(value={"Joe knows Sara"})
    @Documented(value=" Upon successful creation of a relationship, the new relationship is\n returned.\n")
    @TestData.Title(value="Create a relationship with properties")
    public void create_a_relationship_with_properties() throws Exception {
        String jsonString = "{\"to\" : \"" + CreateRelationshipDocTest.getDataUri() + "node/" + this.getNode("Sara").getId() + "\", \"type\" : \"LOVES\", \"data\" : {\"foo\" : \"bar\"}}";
        Node i = this.getNode("Joe");
        ((RESTDocsGenerator)((Object)this.gen.get())).description(this.startGraph("Add relationship with properties before"));
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.CREATED.getStatusCode()).payload(jsonString).post(this.getNodeUri(i) + "/relationships");
        try (Transaction tx = this.graphdb().beginTx();){
            Assert.assertTrue((boolean)i.hasRelationship(new RelationshipType[]{DynamicRelationshipType.withName((String)"LOVES")}));
        }
    }

    @Test
    @Documented(value=" Upon successful creation of a relationship, the new relationship is\n returned.\n")
    @TestData.Title(value="Create relationship")
    @GraphDescription.Graph(value={"Joe knows Sara"})
    public void create_relationship() throws Exception {
        String jsonString = "{\"to\" : \"" + CreateRelationshipDocTest.getDataUri() + "node/" + this.getNode("Sara").getId() + "\", \"type\" : \"LOVES\"}";
        Node i = this.getNode("Joe");
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.CREATED.getStatusCode()).payload(jsonString).description(this.startGraph("create relationship")).post(this.getNodeUri(i) + "/relationships").entity();
        try (Transaction tx = this.graphdb().beginTx();){
            Assert.assertTrue((boolean)i.hasRelationship(new RelationshipType[]{DynamicRelationshipType.withName((String)"LOVES")}));
        }
        this.assertProperRelationshipRepresentation(JsonHelper.jsonToMap((String)entity));
    }

    @Test
    @GraphDescription.Graph(value={"Joe knows Sara"})
    public void shouldRespondWith404WhenStartNodeDoesNotExist() {
        String jsonString = "{\"to\" : \"" + CreateRelationshipDocTest.getDataUri() + "node/" + this.getNode("Joe") + "\", \"type\" : \"LOVES\", \"data\" : {\"foo\" : \"bar\"}}";
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.NOT_FOUND.getStatusCode()).expectedType(MediaType.TEXT_HTML_TYPE).payload(jsonString).post(CreateRelationshipDocTest.getDataUri() + "/node/12345/relationships").entity();
    }

    @Test
    @GraphDescription.Graph(value={"Joe knows Sara"})
    public void creating_a_relationship_to_a_nonexisting_end_node() {
        String jsonString = "{\"to\" : \"" + CreateRelationshipDocTest.getDataUri() + "node/" + "999999\", \"type\" : \"LOVES\", \"data\" : {\"foo\" : \"bar\"}}";
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.BAD_REQUEST.getStatusCode()).payload(jsonString).post(this.getNodeUri(this.getNode("Joe")) + "/relationships").entity();
    }

    @Test
    @GraphDescription.Graph(value={"Joe knows Sara"})
    public void creating_a_loop_relationship() throws Exception {
        Node joe = this.getNode("Joe");
        String jsonString = "{\"to\" : \"" + this.getNodeUri(joe) + "\", \"type\" : \"LOVES\"}";
        String entity = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.CREATED.getStatusCode()).payload(jsonString).post(this.getNodeUri(this.getNode("Joe")) + "/relationships").entity();
        this.assertProperRelationshipRepresentation(JsonHelper.jsonToMap((String)entity));
    }

    @Test
    @GraphDescription.Graph(value={"Joe knows Sara"})
    public void providing_bad_JSON() {
        String jsonString = "{\"to\" : \"" + this.getNodeUri((Node)((Map)this.data.get()).get("Joe")) + "\", \"type\" : \"LOVES\", \"data\" : {\"foo\" : **BAD JSON HERE*** \"bar\"}}";
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(ClientResponse.Status.BAD_REQUEST.getStatusCode()).payload(jsonString).post(this.getNodeUri(this.getNode("Joe")) + "/relationships").entity();
    }

    private void assertProperRelationshipRepresentation(Map<String, Object> relrep) {
        RelationshipRepresentationTest.verifySerialisation(relrep);
    }
}

