/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.metatest.TestJavaTestDocsGenerator;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;
import org.neo4j.server.rest.domain.JsonHelper;

public class ManageNodeDocIT
extends AbstractRestFunctionalDocTestBase {
    private static final long NON_EXISTENT_NODE_ID = 999999L;
    private static String NODE_URI_PATTERN = "^.*/node/[0-9]+$";
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(ManageNodeDocIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    @Test
    public void create_node() throws Exception {
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(201).expectedHeader("Location").post(functionalTestHelper.nodeUri()).response();
        Assert.assertTrue((boolean)response.getLocation().toString().matches(NODE_URI_PATTERN));
    }

    @Test
    public void create_node_with_properties() throws Exception {
        JaxRsResponse response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"foo\" : \"bar\"}").expectedStatus(201).expectedHeader("Location").expectedHeader("Content-Length").post(functionalTestHelper.nodeUri()).response();
        Assert.assertTrue((boolean)response.getLocation().toString().matches(NODE_URI_PATTERN));
        this.checkGeneratedFiles();
    }

    private void checkGeneratedFiles() {
        String graphDocs;
        String responseDocs;
        String requestDocs;
        try {
            requestDocs = TestJavaTestDocsGenerator.readFileAsString((File)new File("target/docs/dev/rest-api/includes/create-node-with-properties.request.asciidoc"));
            responseDocs = TestJavaTestDocsGenerator.readFileAsString((File)new File("target/docs/dev/rest-api/includes/create-node-with-properties.response.asciidoc"));
            graphDocs = TestJavaTestDocsGenerator.readFileAsString((File)new File("target/docs/dev/rest-api/includes/create-node-with-properties.graph.asciidoc"));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading generated documentation file: ", ioe);
        }
        for (String s : new String[]{"POST", "Accept", "application/json", "Content-Type", "{", "foo", "bar", "}"}) {
            Assert.assertThat((Object)requestDocs, (Matcher)Matchers.containsString((String)s));
        }
        for (String s : new String[]{"201", "Created", "Content-Length", "Content-Type", "Location", "{", "foo", "bar", "}"}) {
            Assert.assertThat((Object)responseDocs, (Matcher)Matchers.containsString((String)s));
        }
        for (String s : new String[]{"foo", "bar"}) {
            Assert.assertThat((Object)graphDocs, (Matcher)Matchers.containsString((String)s));
        }
    }

    @Test
    public void create_node_with_array_properties() throws Exception {
        String response = ((RESTDocsGenerator)((Object)this.gen.get())).payload("{\"foo\" : [1,2,3]}").expectedStatus(201).expectedHeader("Location").expectedHeader("Content-Length").post(functionalTestHelper.nodeUri()).response().getEntity();
        Assert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"[ 1, 2, 3 ]"));
    }

    @Documented(value=" Property values can not be null.\n\n This example shows the response you get when trying to set a property to\n +null+.\n")
    @Test
    public void shouldGet400WhenSupplyingNullValueForAProperty() throws Exception {
        ((RESTDocsGenerator)((Object)this.gen.get())).noGraph().payload("{\"foo\":null}").expectedStatus(400).post(functionalTestHelper.nodeUri());
    }

    @Test
    public void shouldGet400WhenCreatingNodeMalformedProperties() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer("this:::isNot::JSON}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    @Test
    public void shouldGet400WhenCreatingNodeUnsupportedNestedPropertyValues() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer("{\"foo\" : {\"bar\" : \"baz\"}}");
        Assert.assertEquals((long)400L, (long)response.getStatus());
    }

    private JaxRsResponse sendCreateRequestToServer(String json) {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/", json);
    }

    private JaxRsResponse sendCreateRequestToServer() {
        return RestRequest.req().post(functionalTestHelper.dataUri() + "node/", null, MediaType.APPLICATION_JSON_TYPE);
    }

    @Test
    public void shouldGetValidLocationHeaderWhenCreatingNode() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer();
        Assert.assertNotNull((Object)response.getLocation());
        Assert.assertTrue((boolean)response.getLocation().toString().startsWith(functionalTestHelper.dataUri() + "node/"));
    }

    @Test
    public void shouldGetASingleContentLengthHeaderWhenCreatingANode() {
        JaxRsResponse response = this.sendCreateRequestToServer();
        List contentLentgthHeaders = (List)response.getHeaders().get((Object)"Content-Length");
        Assert.assertNotNull((Object)contentLentgthHeaders);
        Assert.assertEquals((long)1L, (long)contentLentgthHeaders.size());
    }

    @Test
    public void shouldBeJSONContentTypeOnResponse() {
        JaxRsResponse response = this.sendCreateRequestToServer();
        Assert.assertThat((Object)response.getType().toString(), (Matcher)Matchers.containsString((String)"application/json"));
    }

    @Test
    public void shouldGetValidNodeRepresentationWhenCreatingNode() throws Exception {
        JaxRsResponse response = this.sendCreateRequestToServer();
        String entity = response.getEntity();
        Map map = JsonHelper.jsonToMap((String)entity);
        Assert.assertNotNull((Object)map);
        Assert.assertTrue((boolean)map.containsKey("self"));
    }

    @Documented(value=" Delete node.\n")
    @Test
    public void shouldRespondWith204WhenNodeDeleted() throws Exception {
        long node = helper.createNode(new Label[0]);
        ((RESTDocsGenerator)((Object)this.gen.get())).description(this.startGraph("delete node")).expectedStatus(204).delete(functionalTestHelper.dataUri() + "node/" + node);
    }

    @Test
    public void shouldRespondWith404AndSensibleEntityBodyWhenNodeToBeDeletedCannotBeFound() throws Exception {
        JaxRsResponse response = this.sendDeleteRequestToServer(999999L);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Map jsonMap = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertThat((Object)jsonMap, (Matcher)Matchers.hasKey((Object)"message"));
        Assert.assertNotNull(jsonMap.get("message"));
    }

    @Documented(value=" Nodes with relationships cannot be deleted.\n\n The relationships on a node has to be deleted before the node can be\n deleted.\n \n TIP: You can use `DETACH DELETE` in Cypher to delete nodes and their relationships in one go.\n")
    @Test
    public void shouldRespondWith409AndSensibleEntityBodyWhenNodeCannotBeDeleted() throws Exception {
        long id = helper.createNode(new Label[0]);
        helper.createRelationship("LOVES", id, helper.createNode(new Label[0]));
        JaxRsResponse response = this.sendDeleteRequestToServer(id);
        Assert.assertEquals((long)409L, (long)response.getStatus());
        Map jsonMap = JsonHelper.jsonToMap((String)response.getEntity());
        Assert.assertThat((Object)jsonMap, (Matcher)Matchers.hasKey((Object)"message"));
        Assert.assertNotNull(jsonMap.get("message"));
        ((RESTDocsGenerator)((Object)this.gen.get())).description(this.startGraph("nodes with rels can not be deleted")).noGraph().expectedStatus(409).delete(functionalTestHelper.dataUri() + "node/" + id);
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodePropertiesDuringNodeCreation() throws URISyntaxException {
        String mangledJsonArray = "{\"myprop\":[1,2,\"three\"]}";
        JaxRsResponse response = this.sendCreateRequestToServer(mangledJsonArray);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)mangledJsonArray));
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodeProperty() throws URISyntaxException {
        URI nodeLocation = this.sendCreateRequestToServer().getLocation();
        String mangledJsonArray = "[1,2,\"three\"]";
        JaxRsResponse response = RestRequest.req().put(nodeLocation.toString() + "/properties/myprop", mangledJsonArray);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)mangledJsonArray));
        response.close();
    }

    @Test
    public void shouldRespondWith400IfInvalidJsonSentAsNodeProperties() throws URISyntaxException {
        URI nodeLocation = this.sendCreateRequestToServer().getLocation();
        String mangledJsonProperties = "{\"a\":\"b\", \"c\":[1,2,\"three\"]}";
        JaxRsResponse response = RestRequest.req().put(nodeLocation.toString() + "/properties", mangledJsonProperties);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getType().toString());
        Assert.assertThat((Object)response.getEntity(), (Matcher)Matchers.containsString((String)mangledJsonProperties));
        response.close();
    }

    private JaxRsResponse sendDeleteRequestToServer(long id) throws Exception {
        return RestRequest.req().delete(functionalTestHelper.dataUri() + "node/" + id);
    }
}

