/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.rest;

import java.io.IOException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.server.helpers.FunctionalTestHelper;
import org.neo4j.server.rest.AbstractRestFunctionalDocTestBase;
import org.neo4j.server.rest.JaxRsResponse;
import org.neo4j.server.rest.RESTDocsGenerator;
import org.neo4j.server.rest.RestRequest;
import org.neo4j.server.rest.domain.GraphDbHelper;

public class RemoveNodePropertiesDocIT
extends AbstractRestFunctionalDocTestBase {
    private static FunctionalTestHelper functionalTestHelper;
    private static GraphDbHelper helper;

    @BeforeClass
    public static void setupServer() throws IOException {
        functionalTestHelper = new FunctionalTestHelper(RemoveNodePropertiesDocIT.server());
        helper = functionalTestHelper.getGraphDbHelper();
    }

    private String getPropertiesUri(long nodeId) {
        return functionalTestHelper.nodePropertiesUri(nodeId);
    }

    @Test
    public void shouldReturn204WhenPropertiesAreRemoved() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jim", "tobias");
        helper.setNodeProperties(nodeId, map);
        JaxRsResponse response = this.removeNodePropertiesOnServer(nodeId);
        Assert.assertEquals((long)204L, (long)response.getStatus());
        response.close();
    }

    @Documented(value=" Delete all properties from node.\n")
    @Test
    public void shouldReturn204WhenAllPropertiesAreRemoved() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jim", "tobias");
        helper.setNodeProperties(nodeId, map);
        ((RESTDocsGenerator)((Object)this.gen.get())).description(this.startGraph("delete all prps from node")).expectedStatus(204).delete(functionalTestHelper.nodePropertiesUri(nodeId));
    }

    @Test
    public void shouldReturn404WhenPropertiesSentToANodeWhichDoesNotExist() {
        JaxRsResponse response = RestRequest.req().delete(this.getPropertiesUri(999999L));
        Assert.assertEquals((long)404L, (long)response.getStatus());
        response.close();
    }

    private JaxRsResponse removeNodePropertiesOnServer(long nodeId) {
        return RestRequest.req().delete(this.getPropertiesUri(nodeId));
    }

    @Documented(value=" To delete a single property\n from a node, see the example below.\n")
    @Test
    public void delete_a_named_property_from_a_node() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", "tobias");
        helper.setNodeProperties(nodeId, map);
        ((RESTDocsGenerator)((Object)this.gen.get())).expectedStatus(204).description(this.startGraph("delete named property start")).delete(functionalTestHelper.nodePropertyUri(nodeId, "name"));
    }

    @Test
    public void shouldReturn404WhenRemovingNonExistingNodeProperty() {
        long nodeId = helper.createNode(new Label[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jim", "tobias");
        helper.setNodeProperties(nodeId, map);
        JaxRsResponse response = this.removeNodePropertyOnServer(nodeId, "foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void shouldReturn404WhenPropertySentToANodeWhichDoesNotExist() {
        JaxRsResponse response = RestRequest.req().delete(this.getPropertyUri(999999L, "foo"));
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    private String getPropertyUri(long nodeId, String key) {
        return functionalTestHelper.nodePropertyUri(nodeId, key);
    }

    private JaxRsResponse removeNodePropertyOnServer(long nodeId, String key) {
        return RestRequest.req().delete(this.getPropertyUri(nodeId, key));
    }
}

